//
//  KMTest.m
//  KMTest
//
//  Created by 堀 昌樹 on 12/05/15.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "KMTest.h"

#import "KMRangeArray.h"

@implementation KMTest

- (void)setUp
{
    [super setUp];
    
    // Set-up code here.
}

- (void)tearDown
{
    // Tear-down code here.
    
    [super tearDown];
}

- (void)testKMRange
{
	KMRangeArray *range = [[[KMRangeArray alloc] init] autorelease];
	[range appendRangeWithLength:10];
	[range appendRangeWithLength:10];
	[range appendRangeWithLength:3];
	
	NSRange aRange = [range rangeAtIndex:0];
	STAssertTrue(aRange.location == 0, @"location is not 0.");
	STAssertTrue(aRange.length == 10, @"length is not 10.");
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(0, 10)), @"0 range is not {0, 10}");
	aRange = [range rangeAtIndex:1];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(10, 10)), @"1 range is not {10, 10}");
	aRange = [range rangeAtIndex:2];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(20, 3)), @"2 range is not {20, 3}");
	
	NSIndexSet *set = nil;
	set = [range indexSetInRange:NSMakeRange(0, 5)];
	STAssertTrue([set count] == 1, @"count are %ld", [set count]);
	STAssertTrue([set containsIndex:0], @"");
	set = [range indexSetInRange:NSMakeRange(2, 15)];
	STAssertTrue([set count] == 2, @"count are %ld", [set count]);
	STAssertTrue([set containsIndex:0], @"");
	STAssertTrue([set containsIndex:1], @"");
	
	NSInteger index;
	index = [range firstIndexInRange:NSMakeRange(0, 3)];
	STAssertTrue(index == 0, @"range index is %ld", index);
	index = [range firstIndexInRange:NSMakeRange(21, 3)];
	STAssertTrue(index == 2, @"range index is %ld", index);
	index = [range firstIndexInRange:NSMakeRange(23, 5)];
	STAssertTrue(index == NSNotFound, @"range index is %ld", index);
	
	
	[range insertRangeWithLenght:20 atIndex:1];
	aRange = [range rangeAtIndex:0];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(0, 10)), @"0 range is not {0, 10}");
	aRange = [range rangeAtIndex:1];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(10, 20)), @"1 range is not {10, 20}");
	aRange = [range rangeAtIndex:2];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(30, 10)), @"1 range is not {30, 10}");
	aRange = [range rangeAtIndex:3];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(40, 3)), @"1 range is not {40, 3}");
	
	[range removeAtIndex:2];
	aRange = [range rangeAtIndex:0];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(0, 10)), @"0 range is not {0, 10}");
	aRange = [range rangeAtIndex:1];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(10, 20)), @"1 range is not {10, 20}");
	aRange = [range rangeAtIndex:2];
	STAssertTrue(NSEqualRanges(aRange, NSMakeRange(30, 3)), @"1 range is not {30, 3}");
	
	STAssertThrows([range rangeAtIndex:5], @"");
	STAssertThrows([range insertRangeWithLenght:68 atIndex:9], @"");
	STAssertThrows([range removeAtIndex:89], @"");
}

@end
