//
//  KMThreadDeleter.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 12/03/18.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "KMThreadDeleteCenter.h"

#import "CMRThreadSignature.h"
#import "CMRThreadAttributes.h"
#import "CMRReplyDocumentFileManager.h"
#import "CMRTrashbox.h"

#define kDeletionMessageTextFormatKey @"Deletion Msg"
#define kBrowserDeletionMessageTextKey @"Browser Deletion Msg"
#define kRetrieveMessageTextFormatKey @"Retrieve Msg"
#define kBrowserRetrieveMessageTextKey @"Browser Retrieve Msg"

#define kDeletionInformativeTextKey @"Deletion Info"
#define kRetrieveInformativeTextKey @"Retrieve Info"

#define kDeletionOKButtonLabelKey @"Deletion OK"
#define kRetrieveOKButtonLabelKey @"Retrieve OK"


@implementation KMThreadDeleteCenter
@synthesize delegate = _delegate;

static NSMutableArray *stack = nil;
- (void)push
{
	if(!stack) {
		stack = [[NSMutableArray array] retain];
	}
	[stack addObject:self];
}
- (void)pop
{
	[stack removeObject:self];
}

+ (NSString *)localizableStringsTableName
{
#define APP_TVIEW_LOCALIZABLE_FILE			@"ThreadViewer"
	return APP_TVIEW_LOCALIZABLE_FILE;
}

- (void)deleteThreads:(NSArray *)threads
{
	NSMutableArray	*array_ = [NSMutableArray arrayWithCapacity:[threads count]];
	NSArray			*arrayWithReplyFiles_;
	NSFileManager	*fm = [NSFileManager defaultManager];
	NSString		*path_;
	
	for (id eachItem_ in threads) {
		path_ = [eachItem_ path];
		if ([fm fileExistsAtPath:path_]) {
			[array_ addObject:path_];
		} else {
			NSLog(@"File does not exist (although we're going to remove it!)\n%@", path_);
		}
	}
	
	arrayWithReplyFiles_ = [[CMRReplyDocumentFileManager defaultManager] replyDocumentFilesArrayWithLogsArray:array_];
	[[CMRTrashbox trash] performWithFiles:arrayWithReplyFiles_];
}

- (void)showAlert:(CMRThreadViewerAlertType)type targetThreads:(NSArray *)threads
{
	NSAlert		*alert_;
    NSString *title_;
	
    NSString *titleFormatKey;
	NSString *titleKey;
	NSString *infoTextKey;
    NSString *okBtnKey;
    SEL didEndSelector;
	
	if(!self.delegate) return;
	
    if (type == CMRThreadViewerDeletionAlertType) {		
        titleFormatKey = kDeletionMessageTextFormatKey;
        titleKey = kBrowserDeletionMessageTextKey;
        infoTextKey = kDeletionInformativeTextKey;
        okBtnKey = kDeletionOKButtonLabelKey;
        didEndSelector = @selector(_threadDeletionSheetDidEnd:returnCode:contextInfo:);
    } else {
		if(![self.delegate respondsToSelector:@selector(deleteCenter:retrieveThreads:)]) return;
		
        titleFormatKey = kRetrieveMessageTextFormatKey;
        titleKey = kBrowserRetrieveMessageTextKey;
        infoTextKey = kRetrieveInformativeTextKey;
        okBtnKey = kRetrieveOKButtonLabelKey;
        didEndSelector = @selector(retrieveAlertDidEnd:returnCode:contextInfo:);
    }
	
	alert_ = [[[NSAlert alloc] init] autorelease];
	
    if (!threads || [threads count] < 1) {
        return;
	} else if ([threads count] == 1) {
		NSString *tmp_ = [self localizedString:titleFormatKey];
		NSString *threadTitle_ = @"";
		id thread = [threads lastObject];
		threadTitle_ = [thread threadTitle];
		title_ = [NSString stringWithFormat:tmp_, threadTitle_];
	} else {
		title_ = [self localizedString:titleKey];
	}
	
	[alert_ setMessageText:title_];
	[alert_ setInformativeText:[self localizedString:infoTextKey]];
	[alert_ addButtonWithTitle:[self localizedString:okBtnKey]];
	[alert_ addButtonWithTitle:NSLocalizedString(@"Cancel", @"Cancel")];
	
	[alert_ beginSheetModalForWindow:[self.delegate window] modalDelegate:self didEndSelector:didEndSelector contextInfo:[threads retain]];
	
	[self push];
}

- (void)_threadDeletionSheetDidEnd:(NSAlert *)alert
						returnCode:(NSInteger)returnCode
					   contextInfo:(void *)contextInfo
{
	[self pop];
	if (returnCode == NSAlertFirstButtonReturn) {
        [[alert window] orderOut:nil];
		[self deleteThreads:(NSArray *)contextInfo];
	}
}

- (void)retrieveAlertDidEnd:(NSAlert *)alert returnCode:(NSInteger)code contextInfo:(void *)contextInfo
{
	[self pop];
    if (code != NSAlertFirstButtonReturn) {
        return;
    }
	
    [[alert window] orderOut:nil];
	[self.delegate deleteCenter:self retrieveThreads:(NSArray *)contextInfo];
}
@end
