//
//  KMLogDocumentWindowController.m
//  
//
//  Created by 堀 昌樹 on 11/12/17.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMLogDocumentWindowController.h"
#import "KMDocument.h"
#import "KMLogViewController.h"

#import "CMRReplyDocumentFileManager.h"
#import "CMRTrashbox.h"
#import "AppDefaults.h"

#import "CMRTaskManager.h"
#import "CMRThreadAttributes.h"


static NSMutableArray *_windowControllers = nil;


@interface KMLogDocumentWindowController()
@property (readwrite, retain) id<CMRTask> currentTask;

@property (readonly) NSMutableArray *windowControllers;
@end

@implementation KMLogDocumentWindowController
@dynamic logViewController;

@synthesize currentTask = _currentTask;

- (id)initWithWindow:(NSWindow *)window
{
	self = [super initWithWindow:window];
	if(self) {
		CMRTaskManager *tm = [CMRTaskManager defaultManager];
		[tm addObserver:self
			 forKeyPath:@"currentTask"
				options:0
				context:tm];
		
		[self.windowControllers addObject:self];
	}
	return self;
}
- (void)dealloc
{
	[[CMRTaskManager defaultManager] removeObserver:self forKeyPath:@"currentTask"];
	
	[_currentTask release];
	
	[super dealloc];
}

- (NSMutableArray *)windowControllers
{
	if(_windowControllers) return _windowControllers;
	_windowControllers = [[NSMutableArray alloc] init];
	return _windowControllers;
}


- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == [CMRTaskManager defaultManager]) {
		self.currentTask = [[CMRTaskManager defaultManager] currentTask];
		
		return;
	}
	[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}
+ (NSSet *)keyPathsForValuesAffectingDoc
{
	return [NSSet setWithObject:@"document"];
}
- (KMDocument *)doc
{
	return self.document;
}
+ (NSSet *)keyPathsForValuesAffectingNumberMessages
{
	return [NSSet setWithObjects:@"doc", @"doc.numberOfReadedMessages", nil];
}
- (NSNumber *)numberMessages
{
	NSUInteger num = self.doc.numberOfReadedMessages;
	if(num == 0) return nil;
	return [NSNumber numberWithUnsignedInteger:num];
}
+ (NSSet *)keyPathsForValuesAffectingBoardName
{
	return [NSSet setWithObject:@"doc"];
}
- (NSString *)boardName
{
	return self.doc.boardName;
}
+ (NSSet *)keyPathsForValuesAffectingThreadTitle
{
	return [NSSet setWithObject:@"doc"];
}
- (NSString *)threadTitle
{
	return self.doc.threadTitle;
}

- (void)setDocument:(NSDocument *)document
{
	[self.document performSelector:@selector(removeWindowController:)
						withObject:self
						afterDelay:0.0];
	if(self.document) [self saveDocumentViewAttributes];
	[super setDocument:document];
	[self synchronizeWindowTitleWithDocumentName];
	[self.logViewController setRepresentedObject:document];
	if([self isWindowLoaded]) {
		[self restoreDocumentViewAttributes];
	}
}
- (void)windowDidLoad
{
    [super windowDidLoad];
	[self restoreDocumentViewAttributes];
	
	NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
	[nc addObserver:self
		   selector:@selector(saveDocumentAttributes:)
			   name:NSWindowDidMoveNotification
			 object:self.window];
	[nc addObserver:self
		   selector:@selector(saveDocumentAttributes:)
			   name:NSWindowDidResizeNotification
			 object:self.window];
	[nc addObserver:self
		   selector:@selector(windowWillCloseMine:)
			   name:NSWindowWillCloseNotification
			 object:self.window];
}
- (void)overlayView:(NSView *)view on:(NSView *)placeholder
{
	NSRect placeholderFrame = [placeholder frame];
	
	placeholderFrame.origin.x = 0;
	placeholderFrame.origin.y = 0;
	
	[view setFrame:placeholderFrame];
	[placeholder addSubview:view];
}
- (void)replaceAndFit:(NSView *)view with:(NSView *)oldView
{
	NSView *superView = [oldView superview];
	NSRect frame = [oldView frame];
	[view setFrame:frame];
	[view setAutoresizingMask:[oldView autoresizingMask]];
	[superView replaceSubview:oldView with:view];
}

- (void)saveDocumentAttributes:(NSNotification *)notification
{
	[self saveDocumentViewAttributes];
}
- (void)windowWillCloseMine:(NSNotification *)notification
{
	[self saveDocumentViewAttributes];
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:nil
												  object:self.window];
	
	[[self retain] autorelease];
	[self.windowControllers removeObject:self];
}
- (void)saveDocumentViewAttributes
{
	
}
- (void)restoreDocumentViewAttributes
{
	
}

// CMRTaskManager
+ (NSSet *)keyPathsForValuesAffectingTaskTitle
{
	return [NSSet setWithObject:@"currentTask"];
}
+ (NSSet *)keyPathsForValuesAffectingTaskMessage
{
	return [NSSet setWithObject:@"currentTask"];
}
+ (NSSet *)keyPathsForValuesAffectingTaskInProgress
{
	return [NSSet setWithObject:@"currentTask"];
}
+ (NSSet *)keyPathsForValuesAffectingTaskAmount
{
	return [NSSet setWithObject:@"currentTask"];
}

- (NSString *)taskTitle
{
	return self.currentTask.title;
}
- (NSString *)taskMessage
{
	return self.currentTask.message;
}
- (BOOL) taskInProgress
{
	return self.currentTask.isInProgress;
}
- (double) taskAmount
{
	return self.currentTask.amount;
}
- (IBAction)cancelCurrentTask:(id)sender
{
	[[CMRTaskManager defaultManager] cancel:sender];
}

// For BSThreadInfoPanelController
+ (NSSet *)keyPathsForValuesAffectingThreadAttributes
{
	return [NSSet setWithObjects:@"document", @"document.threadAttr", nil];
}
- (CMRThreadAttributes *)threadAttributes
{
	return self.doc.threadAttr;
}
@end
