//
//  MyBookInformation.m
//  BarcodeScanner
//
//  Created by Hori,Masaki on 11/02/27.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEBookInformation.h"

@interface BEBookInformation (BEPrivate)
@property (nonatomic, retain) NSNumber *primitiveExported;
@end


@implementation BEBookInformation
@dynamic isbn;
@dynamic category;
@dynamic registerDate;
@dynamic tags;
@dynamic review;
@dynamic rating;
@dynamic status;
@dynamic readDate;

@dynamic title;
@dynamic asin;
@dynamic amazonISBN;
@dynamic author;
@dynamic manufacturer;
@dynamic publicationDate;

@dynamic exported;

- (BOOL)exported
{
	[self willAccessValueForKey:@"exported"];
	NSNumber *val = [self primitiveExported];
	[self didAccessValueForKey:@"exported"];
	return val ? [val  boolValue] : NO;
}
- (void)setExported:(BOOL)flag
{
	NSNumber *val = [NSNumber numberWithBool:flag];
	[self willChangeValueForKey:@"exported"];
	[self setPrimitiveExported:val];
	[self didChangeValueForKey:@"exported"];
}

- (NSDate *)registerDate
{
	[self willAccessValueForKey:@"registerDate"];
	NSDate *registerDate = [self primitiveValueForKey:@"registerDate"];
	[self didAccessValueForKey:@"registerDate"];
	if(registerDate) return registerDate;
	registerDate = [[NSDate dateWithTimeIntervalSinceNow:0.0] retain];
	[self setPrimitiveValue:registerDate forKey:@"registerDate"];
	return registerDate;
}
- (NSDate *)readDate
{
	[self willAccessValueForKey:@"readDate"];
	NSDate *readDate = [self primitiveValueForKey:@"readDate"];
	[self didAccessValueForKey:@"readDate"];
	if(readDate) return readDate;
	readDate = [[NSDate dateWithTimeIntervalSinceNow:0.0] retain];
	[self setPrimitiveValue:readDate forKey:@"readDate"];
	return readDate;
}

- (void)setPublicationDate:(id)date
{
	if([date isKindOfClass:[NSString class]]) {
		NSDateFormatter *formatter = [[[NSDateFormatter alloc] init] autorelease];
		[formatter setDateFormat:@"yyyy-MM-dd"];
		date = [formatter dateFromString:date];
	}
	[self willChangeValueForKey:@"publicationDate"];
	[self setPrimitiveValue:date forKey:@"publicationDate"];
	[self didChangeValueForKey:@"publicationDate"];
}
@end
