//
//  AllScanners.m
//  Pediabase
//
//  Created by Farranco on 11/5/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "AllScanners.h"
#import "MyScanner.h"
#import "ZBarScanner.h"

#define BYTES_PER_PIXEL 2 

@implementation AllScanners

- (id)initWithCGRect:(CGRect)aRect {
	self = [super init];
	if (self != nil) {
		
		//intialOffsetMultiplier = 0;
		//nonScannedRowBytes = 0;
		if (aRect.origin.x != 0) {
			intialOffsetMultiplier = 0.25; // We only ever center
		}
		// If we ever capture not at the top of the screen, we are going to need the original display size as well
		//if (aRect.origin.y != 0) {
		//intialOffsetMultiplier += (display.size.height - (aRect.origin.y + aRect.size.height)) * (BYTES_PER_PIXEL * display.size.width);
		//}
		
		width = aRect.size.width;
		height = aRect.size.height;
		grayScale = malloc(width * height);			
		
		myScanner = [[MyScanner alloc] initWithDataBuffer:grayScale height:height width:width];
		zbarScanner = [[ZBarScanner alloc] initWithDataBuffer:grayScale height:height width:width];
		
	}
	return self;
}

- (void) dealloc
{
	[zbarScanner release];
	[myScanner release];
	free(grayScale);
	[super dealloc];
}


//!!! Change color on a crappy scan
- (void)setPreviewView:(SampleCIView *)aView {
	[myScanner setPreviewView:aView];
	[zbarScanner setPreviewView:aView];

	//[previewView release];
	//previewView = [aView retain];
}


- (void)clearGlobalFrequency {
	[myScanner clearGlobalFrequency];
}


- (NSString *)processVideoBuffer:(CVImageBufferRef)pixelBuffer {
	
		CVReturn possibleError = CVPixelBufferLockBaseAddress(pixelBuffer, 0);
		if (possibleError) {
			MyLog(@"Error locking pixel bufffer, when looking for barcode.");
			return nil;
		}
			
		Ptr pixelBufferBaseAddress = (Ptr)CVPixelBufferGetBaseAddress(pixelBuffer); 
		size_t bytesPerRow = CVPixelBufferGetBytesPerRow(pixelBuffer);  //bytes per line
		
		unsigned int offset =  (bytesPerRow * intialOffsetMultiplier) + 1; // Plus one as we want luminace pixel V in YUV 
		//unsigned char prevPixel = 0, nextPixel;
		//unsigned char mainPixel = (unsigned char)pixelBufferBaseAddress[offset];
		int i, j;
		for (i = 0; i < height; i++) { //Last line not scanned to not overflow buffer when doing sharpen mask
			unsigned localOffset = offset;
			for (j = 0; j < width; j++) {
				grayScale[i*width + j] = (unsigned char)pixelBufferBaseAddress[localOffset];
				localOffset += 2;
				/*
				 // This is a deconvulsion based on the neighboring pixels, but it confuses MyScanner, plus Zbar already does deconvulsion on it's scanner
				nextPixel = (unsigned char)pixelBufferBaseAddress[localOffset];			
				grayScale[i*width + j] = (mainPixel * 3 + prevPixel * -1 + nextPixel * -1)/1;
				
				prevPixel = mainPixel;
				mainPixel = nextPixel;
				 */
			}
			offset += bytesPerRow;
		}
	
	//NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	// Looking to replace or supplment one of the scanners here
	NSString *aBarcode = [zbarScanner scan];
	if (aBarcode == nil) {
		aBarcode = [myScanner scan];
		//if (aBarcode)
		//	NSLog(@"My Scanner Found Code");
	}
	//else
		// NSLog(@"Zbar Found Code");
	
	CVPixelBufferUnlockBaseAddress(pixelBuffer, 0);
	
	return aBarcode;
}

@end


