//
//  BSIPreferenceWindowController.m
//  BSInlinePreviewer
//
//  Created by 堀 昌樹 on 12/07/22.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "BSIPreferenceWindowController.h"

#import "BSIPReferenceViewController.h"


@interface BSIPreferenceWindowController ()
@property (retain, nonatomic) BSIPReferenceViewController *contentViewController;
@end

@implementation BSIPreferenceWindowController
@synthesize contentViewController = _contentViewController;

- (id)init
{
	self = [super initWithWindowNibName:NSStringFromClass([self class])];
	
	self.contentViewController = [[[BSIPReferenceViewController alloc] init] autorelease];
	[self.contentViewController addObserver:self
								 forKeyPath:@"thumbnailSize"
									options:0
									context:self.contentViewController];
	
	return self;
}

- (void)windowDidLoad
{
    [super windowDidLoad];
	
	[[self window] setFrameAutosaveName:@"com.masakih.BSInlinePreviewer.BSIPreferenceWindow"];
	[[self window] setContentView:self.contentViewController.view];
}

- (void)dealloc
{
	[self.contentViewController unbind:@"thumbnailSize"];
	[_contentViewController release];
	
	[super dealloc];
}

- (NSSize)thumbnailSize
{
	return self.contentViewController.thumbnailSize;
}
- (void)setThumbnailSize:(NSSize)thumbnailSize
{
	self.contentViewController.thumbnailSize = thumbnailSize;
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == self.contentViewController) {
		[self willChangeValueForKey:@"thumbnailSize"];
		_thumbailSize = self.contentViewController.thumbnailSize;
		[self didChangeValueForKey:@"thumbnailSize"];
		return;
	}
	
	[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}

@end
