﻿
Imports System.Data
Imports System.Configuration
Imports System.Web
Imports System.Net
Imports System.IO


Public Class GZipWebRequest
    Inherits WebRequest


    Private m_wrqRequest As WebRequest
    Private m_stmRequest As Stream
    Private m_blnCompressRequest As Boolean

    Public Sub New(request As WebRequest)
        Me.New(request, False, True)
    End Sub



    Public Sub New(request As WebRequest, compressRequest As Boolean, acceptCompressedResponse As Boolean)
        m_wrqRequest = request
        m_blnCompressRequest = compressRequest
        If compressRequest Then
            m_wrqRequest.Headers("Content-Encoding") = "gzip"
        End If
        If acceptCompressedResponse Then
            m_wrqRequest.Headers("Accept-Encoding") = "gzip"
        End If
    End Sub

    Public Overrides Function GetRequestStream() As System.IO.Stream
        Return WrappedRequestStream(m_wrqRequest.GetRequestStream())
    End Function
    Public Overrides Function BeginGetRequestStream(callback As System.AsyncCallback, state As Object) As System.IAsyncResult
        Return m_wrqRequest.BeginGetRequestStream(callback, state)
    End Function
    Public Overrides Function EndGetRequestStream(asyncResult As System.IAsyncResult) As System.IO.Stream
        Return WrappedRequestStream(m_wrqRequest.EndGetRequestStream(asyncResult))
    End Function

    Private Function WrappedRequestStream(requestStream As Stream) As Stream
        If m_stmRequest Is Nothing Then
            m_stmRequest = requestStream
            If m_blnCompressRequest Then
                '圧縮ライブラリが必要のため
                '          m_stmRequest = New ICSharpCode.SharpZipLib.GZip.GZipOutputStream(m_stmRequest)

            End If
        End If
        Return m_stmRequest
    End Function

    Public Overrides Function GetResponse() As System.Net.WebResponse
        '       Return New GZipWebResponse(m_wrqRequest.GetResponse())
    End Function

    Public Overrides Function BeginGetResponse(callback As System.AsyncCallback, state As Object) As System.IAsyncResult
        Return m_wrqRequest.BeginGetResponse(callback, state)
    End Function

    Public Overrides Function EndGetResponse(asyncResult As System.IAsyncResult) As System.Net.WebResponse
        '        Return New GZipWebResponse(m_wrqRequest.EndGetResponse(asyncResult))
    End Function

    Public Overrides Property Method() As String
        Get
            Return m_wrqRequest.Method
        End Get

        Set(value As String)



            m_wrqRequest.Method = value
        End Set
    End Property




    Public Overrides ReadOnly Property RequestUri() As System.Uri

        Get
            Return m_wrqRequest.RequestUri
        End Get
    End Property

    Public Overrides Property Headers() As System.Net.WebHeaderCollection

        Get

            Return m_wrqRequest.Headers
        End Get

        Set(value As System.Net.WebHeaderCollection)

            m_wrqRequest.Headers = value
        End Set
    End Property


    Public Overrides Property ContentLength() As Long

        Get

            Return m_wrqRequest.ContentLength
        End Get

        Set(value As Long)


            m_wrqRequest.ContentLength = value
        End Set
    End Property

    Public Overrides Property ContentType() As String

        Get



            Return m_wrqRequest.ContentType
        End Get

        Set(value As String)



            m_wrqRequest.ContentType = value
        End Set
    End Property




    Public Overrides Property Credentials() As System.Net.ICredentials


        Get



            Return m_wrqRequest.Credentials
        End Get

        Set(value As System.Net.ICredentials)



            m_wrqRequest.Credentials = value
        End Set
    End Property




    Public Overrides Property PreAuthenticate() As Boolean


        Get



            Return m_wrqRequest.PreAuthenticate
        End Get

        Set(value As Boolean)



            m_wrqRequest.PreAuthenticate = True
        End Set
    End Property




End Class
