/*
	Copyright (C) 2009-2013 jakago

	This file is part of CaptureStream, the flv downloader for NHK radio
	language courses.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "downloadthread.h"
#include "customizedialog.h"
#include "scrambledialog.h"
#include "utility.h"
#include "qt4qt5.h"

#include <QMessageBox>
#include <QByteArray>
#include <QXmlQuery>
#include <QStringList>
#include <QProcess>
#include <QCoreApplication>
#include <QFile>
#include <QDir>
#include <QFileInfo>
#include <QThread>
#include <QSettings>
#include <QDesktopWidget>
#include <QInputDialog>
#include <QFileDialog>
#include <QTextStream>

#define SETTING_GROUP "MainWindow"
#define SETTING_GEOMETRY "geometry"
#define SETTING_SAVE_FOLDER "save_folder"
#define SETTING_SCRAMBLE "scramble"
#define SETTING_SCRAMBLE_URL1 "scramble_url1"
#define SETTING_SCRAMBLE_URL2 "scramble_url2"
#define SETTING_OPTIONAL1 "optional1"
#define SETTING_OPTIONAL2 "optional2"
#define SETTING_OPTIONAL3 "optional3"
#define SETTING_OPTIONAL4 "optional4"
#define SETTING_OPTIONAL5 "optional5"
#define SETTING_OPTIONAL6 "optional6"
#define SETTING_OPTIONAL7 "optional7"
#define SETTING_OPTIONAL8 "optional8"
#define SETTING_OPT_TITLE1 "opt_title1"
#define SETTING_OPT_TITLE2 "opt_title2"
#define SETTING_OPT_TITLE3 "opt_title3"
#define SETTING_OPT_TITLE4 "opt_title4"
#define SETTING_french_TITLE1 "french_title1"
#define SETTING_french_TITLE2 "french_title2"
#define SETTING_german_TITLE1 "german_title1"
#define SETTING_german_TITLE2 "german_title2"
#define SETTING_spanish_TITLE1 "spanish_title1"
#define SETTING_spanish_TITLE2 "spanish_title2"
#define SETTING_italian_TITLE1 "italian_title1"
#define SETTING_italian_TITLE2 "italian_title2"
#define SETTING_russian_TITLE1 "russian_title1"
#define SETTING_russian_TITLE2 "russian_title2"
#define SCRAMBLE_URL1 "http://www47.atwiki.jp/jakago/pub/scramble.xml"
#define SCRAMBLE_URL2 "http://cdn47.atwikiimg.com/jakago/pub/scramble.xml"
#define OPTIONAL1 "french/kouza"
#define OPTIONAL2 "french/kouza2"
#define OPTIONAL3 "german/kouza"
#define OPTIONAL4 "german/kouza2"
#define OPTIONAL5 "english/basic1"
#define OPTIONAL6 "english/basic2"
#define OPTIONAL7 "english/basic3"
#define OPTIONAL8 "english/enjoy"
#define English_TITLE1 "任意講座１"
#define English_TITLE2 "任意講座２"
#define English_TITLE3 "任意講座３"
#define English_TITLE4 "任意講座４"
#define French_TITLE1 "まいにちフランス語【入門編】"
#define French_TITLE2 "まいにちフランス語【応用編】"
#define German_TITLE1 "まいにちドイツ語【初級編】"
#define German_TITLE2 "まいにちドイツ語【応用編】"
#define Spanish_TITLE1 "まいにちスペイン語【入門編】"
#define Spanish_TITLE2 "まいにちスペイン語【中級編】"
#define Italian_TITLE1 "まいにちイタリア語【初級編】"
#define Italian_TITLE2 "まいにちイタリア語【応用編】"
#define Russian_TITLE1 "まいにちロシア語【入門編】"
#define Russian_TITLE2 "まいにちロシア語【応用編】"

#define X11_WINDOW_VERTICAL_INCREMENT 5

#ifdef QT4_QT5_WIN
#define STYLE_SHEET "stylesheet-win.qss"
#else
#ifdef QT4_QT5_MAC
#define STYLE_SHEET "stylesheet-mac.qss"
#else
#define STYLE_SHEET "stylesheet-ubu.qss"
#endif
#endif

namespace {
	bool outputDirSpecified = false;
	QString version() {
		QString result;
		// 日本語ロケールではQDate::fromStringで曜日なしは動作しないのでQRegExpを使う
		// __DATE__の形式： "Jul  8 2011"
		static QRegExp regexp( "([a-zA-Z]{3})\\s+(\\d{1,2})\\s+(\\d{4})" );
		static QStringList months = QStringList()
				<< "Jan" << "Feb" << "Mar" << "Apr" << "May" << "Jun"
				<< "Jul" << "Aug" << "Sep" << "Oct" << "Nov" << "Dec";
		if ( regexp.indexIn( __DATE__ ) != -1 ) {
			int month = months.indexOf( regexp.cap( 1 ) ) + 1;
			int day = regexp.cap( 2 ).toInt();
			result = QString( " (%1/%2/%3)" ).arg( regexp.cap( 3 ) )
					.arg( month, 2, 10, QLatin1Char( '0' ) ).arg( day, 2, 10, QLatin1Char( '0' ) );
		}
		return result;
	}
}

QString MainWindow::outputDir;
QString MainWindow::scramble;
QString MainWindow::scrambleUrl1;
QString MainWindow::scrambleUrl2;
QString MainWindow::optional1;
QString MainWindow::optional2;
QString MainWindow::optional3;
QString MainWindow::optional4;
QString MainWindow::optional5;
QString MainWindow::optional6;
QString MainWindow::optional7;
QString MainWindow::optional8;
QString MainWindow::english_title1;
QString MainWindow::english_title2;
QString MainWindow::english_title3;
QString MainWindow::english_title4;
QString MainWindow::french_title1;
QString MainWindow::french_title2;
QString MainWindow::german_title1;
QString MainWindow::german_title2;
QString MainWindow::spanish_title1;
QString MainWindow::spanish_title2;
QString MainWindow::italian_title1;
QString MainWindow::italian_title2;
QString MainWindow::russian_title1;
QString MainWindow::russian_title2;
QString MainWindow::prefix = "http://cgi2.nhk.or.jp/gogaku/st/xml/";
QString MainWindow::suffix = "listdataflv.xml";


MainWindow::MainWindow( QWidget *parent )
		: QMainWindow( parent ), ui( new Ui::MainWindowClass ), downloadThread( NULL ) {
	ui->setupUi( this );
	settings( ReadMode );
	this->setWindowTitle( this->windowTitle() + version() );

#ifdef QT4_QT5_MAC		// Macのウィンドウにはメニューが出ないので縦方向に縮める
	setMaximumHeight( maximumHeight() - menuBar()->height() );
	setMinimumHeight( maximumHeight() - menuBar()->height() );
	QRect rect = geometry();
	rect.setHeight( rect.height() - menuBar()->height() );
	rect.moveTop( rect.top() + menuBar()->height() );	// 4.6.3だとこれがないとウィンドウタイトルがメニューバーに隠れる
	setGeometry( rect );
#endif
#ifdef Q_OS_LINUX		// Linuxでは高さが足りなくなるので縦方向に伸ばしておく
	setMaximumHeight( maximumHeight() + X11_WINDOW_VERTICAL_INCREMENT );
	setMinimumHeight( maximumHeight() + X11_WINDOW_VERTICAL_INCREMENT );
	QRect rect = geometry();
	rect.setHeight( rect.height() + X11_WINDOW_VERTICAL_INCREMENT );
	setGeometry( rect );
#endif

#if !defined( QT4_QT5_MAC ) && !defined( QT4_QT5_WIN )
	QPoint bottomLeft = geometry().bottomLeft();
	bottomLeft += QPoint( 0, menuBar()->height() + statusBar()->height() + 3 );
	messagewindow.move( bottomLeft );
#endif

	// 「カスタマイズ」メニューの構築
	customizeMenu = menuBar()->addMenu( QString::fromUtf8( "カスタマイズ" ) );

	QAction* action = new QAction( QString::fromUtf8( "ファイル名設定..." ), this );
	connect( action, SIGNAL( triggered() ), this, SLOT( customizeFileName() ) );
	customizeMenu->addAction( action );

	action = new QAction( QString::fromUtf8( "タイトルタグ設定..." ), this );
	connect( action, SIGNAL( triggered() ), this, SLOT( customizeTitle() ) );
	customizeMenu->addAction( action );

	action = new QAction( QString::fromUtf8( "保存フォルダ..." ), this );
	connect( action, SIGNAL( triggered() ), this, SLOT( customizeSaveFolder() ) );
	customizeMenu->addAction( action );

	action = new QAction( QString::fromUtf8( "任意講座設定" ), this );
	connect( action, SIGNAL( triggered() ), this, SLOT( customizeScramble() ) );
	customizeMenu->addAction( action );

	//action = new QAction( QString::fromUtf8( "スクランブル文字列..." ), this );
	//connect( action, SIGNAL( triggered() ), this, SLOT( customizeScramble() ) );
	//customizeMenu->addAction( action );

	QString styleSheet;
	QFile real( Utility::applicationBundlePath() + STYLE_SHEET );
	if ( real.exists() ) {
		real.open( QFile::ReadOnly );
		styleSheet = QLatin1String( real.readAll() );
	} else {
		QFile res( QString( ":/" ) + STYLE_SHEET );
		res.open( QFile::ReadOnly );
		styleSheet = QLatin1String( res.readAll() );
	}
	qApp->setStyleSheet( styleSheet );
}

MainWindow::~MainWindow() {
	if ( downloadThread ) {
		downloadThread->terminate();
		delete downloadThread;
	}
	if ( !Utility::nogui() )
		settings( WriteMode );
	delete ui;
}

void MainWindow::closeEvent( QCloseEvent *event ) {
	Q_UNUSED( event )
	if ( downloadThread ) {
		messagewindow.appendParagraph( QString::fromUtf8( "ダウンロードをキャンセル中..." ) );
		download();
	}
	messagewindow.close();
	QCoreApplication::exit();
}

void MainWindow::settings( enum ReadWriteMode mode ) {
	typedef struct CheckBox {
		QAbstractButton* checkBox;
		QString key;
		QVariant defaultValue;
		QString titleKey;
		QVariant titleFormat;
		QString fileNameKey;
		QVariant fileNameFormat;
	} CheckBox;
#define DefaultTitle "%k_%Y_%M_%D"
#define DefaultFileName "%k_%Y_%M_%D.m4a"
	CheckBox checkBoxes[] = {
		{ ui->toolButton_chinese, "chinese", false, "chinese_title", DefaultTitle, "chinese_file_name", DefaultFileName },
		{ ui->toolButton_french, "french", false, "french_title", DefaultTitle, "french_file_name", DefaultFileName },
		{ ui->toolButton_french2, "french2", false, "french_title", DefaultTitle, "french_file_name", DefaultFileName },
		{ ui->toolButton_italian, "italian", false, "italian_title", DefaultTitle, "italian_file_name", DefaultFileName },
		{ ui->toolButton_italian2, "italian2", false, "italian_title", DefaultTitle, "italian_file_name", DefaultFileName },
		{ ui->toolButton_hangeul, "hangeul", false, "hangeul_title", DefaultTitle, "hangeul_file_name", DefaultFileName },
		{ ui->toolButton_german, "german", false, "german_title", DefaultTitle, "german_file_name", DefaultFileName },
		{ ui->toolButton_german2, "german2", false, "german_title", DefaultTitle, "german_file_name", DefaultFileName },
		{ ui->toolButton_spanish, "spanish", false, "spanish_title", DefaultTitle, "spanish_file_name", DefaultFileName },
		{ ui->toolButton_spanish2, "spanish2", false, "spanish_title", DefaultTitle, "spanish_file_name", DefaultFileName },
		{ ui->toolButton_levelup_chinese, "levelup-chinese", false, "levelup-chinese_title", DefaultTitle, "levelup-chinese_file_name", DefaultFileName },
		{ ui->toolButton_omotenashino_chinese, "omotenashino-chinese", false, "omotenashino-chinese_title", DefaultTitle, "omotenashino-chinese_file_name", DefaultFileName },
		{ ui->toolButton_omotenashino_hangeul, "omotenashino-hangeul", false, "omotenashino-hangeul_title", DefaultTitle, "omotenashino-hangeul_file_name", DefaultFileName },
		{ ui->toolButton_levelup_hangeul, "levelup-hangeul", false, "levelup-hangeul_title", DefaultTitle, "levelup-hangeul_file_name", DefaultFileName },
		{ ui->toolButton_russian, "russian", false, "russian_title", DefaultTitle, "russian_file_name", DefaultFileName },
		{ ui->toolButton_russian2, "russian2", false, "russian_title", DefaultTitle, "russian_file_name", DefaultFileName },
		{ ui->toolButton_optional1, "optional_1", false, "optional1_title", DefaultTitle, "optional1_file_name", DefaultFileName },
		{ ui->toolButton_optional2, "optional_2", false, "optional2_title", DefaultTitle, "optional2_file_name", DefaultFileName },
		{ ui->toolButton_optional3, "optional_3", false, "optional3_title", DefaultTitle, "optional3_file_name", DefaultFileName },
		{ ui->toolButton_optional4, "optional_4", false, "optional4_title", DefaultTitle, "optional4_file_name", DefaultFileName },
		{ ui->checkBox_shower, "shower", false, "shower_title", DefaultTitle, "shower_file_name", DefaultFileName },
		{ ui->toolButton_skip, "skip", true, "", "", "", "" },
		{ ui->checkBox_keep_on_error, "keep_on_error", false, "", "", "", "" },
		{ ui->checkBox_this_week, "this_week", true, "", "", "", "" },
		{ ui->checkBox_next_week, "next_week", false, "", "", "", "" },
		{ ui->checkBox_past_week, "past_week", false, "", "", "", "" },
		{ ui->toolButton_detailed_message, "detailed_message", false, "", "", "", "" },
		{ NULL, NULL, false, "", "", "", "" }
	};
	typedef struct ComboBox {
		QComboBox* comboBox;
		QString key;
		QVariant defaultValue;
	} ComboBox;
	ComboBox comboBoxes[] = {
		{ ui->comboBox_enews, "e-news-index", ENewsSaveBoth },
		{ ui->comboBox_shower, "shower_index", ENewsSaveBoth },
		{ NULL, NULL, false }
	};
	ComboBox textComboBoxes[] = {
		{ ui->comboBox_extension, "audio_extension", "m4a" },
		{ NULL, NULL, false }
	};

	QSettings settings( Utility::applicationBundlePath() + INI_FILE, QSettings::IniFormat );
	settings.beginGroup( SETTING_GROUP );

	if ( mode == ReadMode ) {	// 設定読み込み
		QVariant saved;
#if defined( QT4_QT5_MAC ) || defined( QT4_QT5_WIN )	// X11では正しく憶えられないので位置をリストアしない
		saved = settings.value( SETTING_GEOMETRY );
		if ( saved.type() == QVariant::Invalid )
			move( 70, 22 );
		else {
			// ウィンドウサイズはバージョン毎に変わる可能性があるのでウィンドウ位置だけリストアする
			QSize windowSize = size();
			restoreGeometry( saved.toByteArray() );
			resize( windowSize );
		}
#endif

		saved = settings.value( SETTING_SAVE_FOLDER );
		outputDir = saved.type() == QVariant::Invalid ? Utility::applicationBundlePath() : saved.toString();

		saved = settings.value( SETTING_SCRAMBLE );
		scramble = saved.type() == QVariant::Invalid ? "" : saved.toString();

		saved = settings.value( SETTING_SCRAMBLE_URL1 );
		scrambleUrl1 = saved.type() == QVariant::Invalid ? SCRAMBLE_URL1 : saved.toString();
		saved = settings.value( SETTING_SCRAMBLE_URL2 );
		scrambleUrl2 = saved.type() == QVariant::Invalid ? SCRAMBLE_URL2 : saved.toString();

		saved = settings.value( SETTING_OPTIONAL1 );
		optional1 = saved.type() == QVariant::Invalid ? OPTIONAL1 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL2 );
		optional2 = saved.type() == QVariant::Invalid ? OPTIONAL2 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL3 );
		optional3 = saved.type() == QVariant::Invalid ? OPTIONAL3 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL4 );
		optional4 = saved.type() == QVariant::Invalid ? OPTIONAL4 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL5 );
		optional5 = saved.type() == QVariant::Invalid ? OPTIONAL5 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL6 );
		optional6 = saved.type() == QVariant::Invalid ? OPTIONAL6 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL7 );
		optional7 = saved.type() == QVariant::Invalid ? OPTIONAL7 : saved.toString();
		saved = settings.value( SETTING_OPTIONAL8 );
		optional8 = saved.type() == QVariant::Invalid ? OPTIONAL8 : saved.toString();

		saved = settings.value( SETTING_OPT_TITLE1 );
		english_title1 = saved.type() == QVariant::Invalid ? QString::fromUtf8( English_TITLE1 ) : saved.toString();
		saved = settings.value( SETTING_OPT_TITLE2 );
		english_title2 = saved.type() == QVariant::Invalid ? QString::fromUtf8( English_TITLE2 ) : saved.toString();
		saved = settings.value( SETTING_OPT_TITLE3 );
		english_title3 = saved.type() == QVariant::Invalid ? QString::fromUtf8( English_TITLE3 ) : saved.toString();
		saved = settings.value( SETTING_OPT_TITLE4 );
		english_title4 = saved.type() == QVariant::Invalid ? QString::fromUtf8( English_TITLE4 ) : saved.toString();

		saved = settings.value( SETTING_french_TITLE1 );
		french_title1 = saved.type() == QVariant::Invalid ? QString::fromUtf8( French_TITLE1 ) : saved.toString();
		saved = settings.value( SETTING_french_TITLE2 );
		french_title2 = saved.type() == QVariant::Invalid ? QString::fromUtf8( French_TITLE2 ) : saved.toString();
		saved = settings.value( SETTING_german_TITLE1 );
		german_title1 = saved.type() == QVariant::Invalid ? QString::fromUtf8( German_TITLE1 ) : saved.toString();
		saved = settings.value( SETTING_german_TITLE2 );
		german_title2 = saved.type() == QVariant::Invalid ? QString::fromUtf8( German_TITLE2 ) : saved.toString();
		saved = settings.value( SETTING_spanish_TITLE1 );
		spanish_title1 = saved.type() == QVariant::Invalid ? QString::fromUtf8( Spanish_TITLE1 ) : saved.toString();
		saved = settings.value( SETTING_spanish_TITLE2 );
		spanish_title2 = saved.type() == QVariant::Invalid ? QString::fromUtf8( Spanish_TITLE2 ) : saved.toString();
		saved = settings.value( SETTING_italian_TITLE1 );
		italian_title1 = saved.type() == QVariant::Invalid ? QString::fromUtf8( Italian_TITLE1 ) : saved.toString();
		saved = settings.value( SETTING_italian_TITLE2 );
		italian_title2 = saved.type() == QVariant::Invalid ? QString::fromUtf8( Italian_TITLE2 ) : saved.toString();
		saved = settings.value( SETTING_russian_TITLE1 );
		russian_title1 = saved.type() == QVariant::Invalid ? QString::fromUtf8( Russian_TITLE1 ) : saved.toString();
		saved = settings.value( SETTING_russian_TITLE2 );
		russian_title2 = saved.type() == QVariant::Invalid ? QString::fromUtf8( Russian_TITLE2 ) : saved.toString();

		ui->toolButton_optional1->setText( QString( english_title1 ) );
		ui->toolButton_optional2->setText( QString( english_title2 ) );
		ui->toolButton_optional3->setText( QString( english_title3 ) );
		ui->toolButton_optional4->setText( QString( english_title4 ) );

		ui->toolButton_french->setText( QString( french_title1 ) );
		ui->toolButton_french2->setText( QString( french_title2 ) );
		ui->toolButton_german->setText( QString( german_title1 ) );
		ui->toolButton_german2->setText( QString( german_title2 ) );
		ui->toolButton_spanish->setText( QString( spanish_title1 ) );
		ui->toolButton_spanish2->setText( QString( spanish_title2 ) );
		ui->toolButton_italian->setText( QString( italian_title1 ) );
		ui->toolButton_italian2->setText( QString( italian_title2 ) );
		ui->toolButton_russian->setText( QString( russian_title1 ) );
		ui->toolButton_russian2->setText( QString( russian_title2 ) );

		QStringList french_TITLE1 = getAttribute( prefix + optional1 + "/" + suffix, "@kouza" );
		QStringList french_TITLE2 = getAttribute( prefix + optional2 + "/" + suffix, "@kouza" );
		QStringList german_TITLE1 = getAttribute( prefix + optional3 + "/" + suffix, "@kouza" );
		QStringList german_TITLE2 = getAttribute( prefix + optional4 + "/" + suffix, "@kouza" );
		QStringList spanish_TITLE1 = getAttribute( prefix + "spanish/kouza" + "/" + suffix, "@kouza" );
		QStringList spanish_TITLE2 = getAttribute( prefix + "spanish/kouza2" + "/" + suffix, "@kouza" );
		QStringList italian_TITLE1 = getAttribute( prefix + "italian/kouza" + "/" + suffix, "@kouza" );
		QStringList italian_TITLE2 = getAttribute( prefix + "italian/kouza2" + "/" + suffix, "@kouza" );
		QStringList russian_TITLE1 = getAttribute( prefix + "russian/kouza" + "/" + suffix, "@kouza" );
		QStringList russian_TITLE2 = getAttribute( prefix + "russian/kouza2" + "/" + suffix, "@kouza" );

		QStringList opt_TITLE1 = getAttribute( prefix + optional5 + "/" + suffix, "@kouza" );
		QStringList opt_TITLE2 = getAttribute( prefix + optional6 + "/" + suffix, "@kouza" );
		QStringList opt_TITLE3 = getAttribute( prefix + optional7 + "/" + suffix, "@kouza" );
		QStringList opt_TITLE4 = getAttribute( prefix + optional8 + "/" + suffix, "@kouza" );

		english_title1 = opt_TITLE1[0];
		english_title2 = opt_TITLE2[0];
		english_title3 = opt_TITLE3[0];
		english_title4 = opt_TITLE4[0];
		french_title1 = french_TITLE1[0];
		french_title2 = french_TITLE2[0];
		german_title1 = german_TITLE1[0];
		german_title2 = german_TITLE2[0];	
		spanish_title1 = spanish_TITLE1[0];
		spanish_title2 = spanish_TITLE2[0];
		italian_title1 = italian_TITLE1[0];
		italian_title2 = italian_TITLE2[0];
		russian_title1 = russian_TITLE1[0];
		russian_title2 = russian_TITLE2[0];

		ui->toolButton_optional1->setText( QString( english_title1 ) );
		ui->toolButton_optional2->setText( QString( english_title2 ) );
		ui->toolButton_optional3->setText( QString( english_title3 ) );
		ui->toolButton_optional4->setText( QString( english_title4 ) );

		ui->toolButton_french->setText( QString( french_title1 ) );
		ui->toolButton_french2->setText( QString( french_title2 ) );
		ui->toolButton_german->setText( QString( german_title1 ) );
		ui->toolButton_german2->setText( QString( german_title2 ) );
		ui->toolButton_spanish->setText( QString( spanish_title1 ) );
		ui->toolButton_spanish2->setText( QString( spanish_title2 ) );
		ui->toolButton_italian->setText( QString( italian_title1 ) );
		ui->toolButton_italian2->setText( QString( italian_title2 ) );
		ui->toolButton_russian->setText( QString( russian_title1 ) );
		ui->toolButton_russian2->setText( QString( russian_title2 ) );



		for ( int i = 0; checkBoxes[i].checkBox != NULL; i++ ) {
			checkBoxes[i].checkBox->setChecked( settings.value( checkBoxes[i].key, checkBoxes[i].defaultValue ).toBool() );
		}
		for ( int i = 0; comboBoxes[i].comboBox != NULL; i++ )
			comboBoxes[i].comboBox->setCurrentIndex( settings.value( comboBoxes[i].key, comboBoxes[i].defaultValue ).toInt() );
		for ( int i = 0; textComboBoxes[i].comboBox != NULL; i++ ) {
			QString extension = settings.value( textComboBoxes[i].key, textComboBoxes[i].defaultValue ).toString();
			textComboBoxes[i].comboBox->setCurrentIndex( textComboBoxes[i].comboBox->findText( extension ) );
		}
	} else {	// 設定書き出し
#if defined( QT4_QT5_MAC ) || defined( QT4_QT5_WIN )
		settings.setValue( SETTING_GEOMETRY, saveGeometry() );
#endif
		if ( outputDirSpecified )
			settings.setValue( SETTING_SAVE_FOLDER, outputDir );
		settings.setValue( SETTING_SCRAMBLE, scramble );
		settings.setValue( SETTING_SCRAMBLE_URL1, scrambleUrl1 );
		settings.setValue( SETTING_SCRAMBLE_URL2, scrambleUrl2 );
		settings.setValue( SETTING_OPTIONAL1, optional1 );
		settings.setValue( SETTING_OPTIONAL2, optional2 );
		settings.setValue( SETTING_OPTIONAL3, optional3 );
		settings.setValue( SETTING_OPTIONAL4, optional4 );
		settings.setValue( SETTING_OPTIONAL5, optional5 );
		settings.setValue( SETTING_OPTIONAL6, optional6 );
		settings.setValue( SETTING_OPTIONAL7, optional7 );
		settings.setValue( SETTING_OPTIONAL8, optional8 );
		settings.setValue( SETTING_OPT_TITLE1, english_title1 );
		settings.setValue( SETTING_OPT_TITLE2, english_title2 );
		settings.setValue( SETTING_OPT_TITLE3, english_title3 );
		settings.setValue( SETTING_OPT_TITLE4, english_title4 );

		settings.setValue( SETTING_french_TITLE1, french_title1 );
		settings.setValue( SETTING_french_TITLE2, french_title2 );
		settings.setValue( SETTING_german_TITLE1, german_title1 );
		settings.setValue( SETTING_german_TITLE2, german_title2 );
		settings.setValue( SETTING_spanish_TITLE1, spanish_title1 );
		settings.setValue( SETTING_spanish_TITLE2, spanish_title2 );
		settings.setValue( SETTING_italian_TITLE1, italian_title1 );
		settings.setValue( SETTING_italian_TITLE2, italian_title2 );
		settings.setValue( SETTING_russian_TITLE1, russian_title1 );
		settings.setValue( SETTING_russian_TITLE2, russian_title2 );

		for ( int i = 0; checkBoxes[i].checkBox != NULL; i++ ) {
			settings.setValue( checkBoxes[i].key, checkBoxes[i].checkBox->isChecked() );
		}
		for ( int i = 0; comboBoxes[i].comboBox != NULL; i++ )
			settings.setValue( comboBoxes[i].key, comboBoxes[i].comboBox->currentIndex() );
		for ( int i = 0; textComboBoxes[i].comboBox != NULL; i++ )
			settings.setValue( textComboBoxes[i].key, textComboBoxes[i].comboBox->currentText() );
	}

	settings.endGroup();
}

void MainWindow::customizeTitle() {
	CustomizeDialog dialog( Ui::TitleMode );
	dialog.exec();
}

void MainWindow::customizeFileName() {
	CustomizeDialog dialog( Ui::FileNameMode );
	dialog.exec();
}

void MainWindow::customizeSaveFolder() {
	QString dir = QFileDialog::getExistingDirectory( 0, QString::fromUtf8( "保存フォルダを指定してください" ),
									   outputDir, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks );
	if ( dir.length() ) {
		outputDir = dir + QDir::separator();
		outputDirSpecified = true;
	}
}


void MainWindow::customizeScramble() {
	ScrambleDialog dialog( optional1, optional2, optional3, optional4, optional5, optional6, optional7, optional8 );
	dialog.exec();
	optional1 = dialog.scramble1();
	optional2 = dialog.scramble2();
	optional3 = dialog.scramble3();
	optional4 = dialog.scramble4();
	optional5 = dialog.scramble5();
	optional6 = dialog.scramble6();
	optional7 = dialog.scramble7();
	optional8 = dialog.scramble8();

	QStringList french_TITLE1 = getAttribute( prefix + optional1 + "/" + suffix, "@kouza" );
	QStringList french_TITLE2 = getAttribute( prefix + optional2 + "/" + suffix, "@kouza" );
	QStringList german_TITLE1 = getAttribute( prefix + optional3 + "/" + suffix, "@kouza" );
	QStringList german_TITLE2 = getAttribute( prefix + optional4 + "/" + suffix, "@kouza" );

	QStringList opt_TITLE1 = getAttribute( prefix + optional5 + "/" + suffix, "@kouza" );
	QStringList opt_TITLE2 = getAttribute( prefix + optional6 + "/" + suffix, "@kouza" );
	QStringList opt_TITLE3 = getAttribute( prefix + optional7 + "/" + suffix, "@kouza" );
	QStringList opt_TITLE4 = getAttribute( prefix + optional8 + "/" + suffix, "@kouza" );

	english_title1 = opt_TITLE1[0];
	english_title2 = opt_TITLE2[0];
	english_title3 = opt_TITLE3[0];
	english_title4 = opt_TITLE4[0];
	french_title1 = french_TITLE1[0];
	french_title2 = french_TITLE2[0];
	german_title1 = german_TITLE1[0];
	german_title2 = german_TITLE2[0];	

	ui->toolButton_optional1->setText( QString( english_title1 ) );
	ui->toolButton_optional2->setText( QString( english_title2 ) );
	ui->toolButton_optional3->setText( QString( english_title3 ) );
	ui->toolButton_optional4->setText( QString( english_title4 ) );
	ui->toolButton_french->setText( QString( french_title1 ) );
	ui->toolButton_french2->setText( QString( french_title2 ) );
	ui->toolButton_german->setText( QString( german_title1 ) );
	ui->toolButton_german2->setText( QString( german_title2 ) );
}

void MainWindow::download() {	//「ダウンロード」または「キャンセル」ボタンが押されると呼び出される
	if ( !downloadThread ) {	//ダウンロード実行
		if ( messagewindow.text().length() > 0 )
			messagewindow.appendParagraph( "\n----------------------------------------" );
		ui->downloadButton->setEnabled( false );
		downloadThread = new DownloadThread( ui );
		connect( downloadThread, SIGNAL( finished() ), this, SLOT( finished() ) );
		connect( downloadThread, SIGNAL( critical( QString ) ), &messagewindow, SLOT( appendParagraph( QString ) ), Qt::BlockingQueuedConnection );
		connect( downloadThread, SIGNAL( information( QString ) ), &messagewindow, SLOT( appendParagraph( QString ) ), Qt::BlockingQueuedConnection );
		connect( downloadThread, SIGNAL( current( QString ) ), &messagewindow, SLOT( appendParagraph( QString ) ) );
		connect( downloadThread, SIGNAL( messageWithoutBreak( QString ) ), &messagewindow, SLOT( append( QString ) ) );
		downloadThread->start();
		ui->downloadButton->setText( QString::fromUtf8( "キャンセル" ) );
		ui->downloadButton->setEnabled( true );
	} else {	//キャンセル
		downloadThread->disconnect();	//wait中にSIGNALが発生するとデッドロックするためすべてdisconnect
		finished();
	}
}

QStringList MainWindow::getAttribute( QString url, QString attribute ) {
	const QString xmlUrl = "doc('" + url + "')/musicdata/music/" + attribute + "/string()";
	QStringList attributeList;
	QXmlQuery query;
	query.setQuery( xmlUrl );
	if ( query.isValid() )
		query.evaluateTo( &attributeList );
	return attributeList;
}

void MainWindow::toggled( bool checked ) {
	QObject* sender = this->sender();
	if ( sender ) {
		QToolButton* button = (QToolButton*)sender;
		QString text = button->text();
		if ( checked )
			text.insert( 0, QString::fromUtf8( "✓ " ) );
		else
			text.remove( 0, 2 );
		button->setText( text );
	}
}

void MainWindow::finished() {
	if ( downloadThread ) {
		ui->downloadButton->setEnabled( false );
		if ( downloadThread->isRunning() ) {	//キャンセルでMainWindow::downloadから呼ばれた場合
			downloadThread->cancel();
			downloadThread->wait();
			messagewindow.appendParagraph( QString::fromUtf8( "ダウンロードをキャンセルしました。" ) );
		}
		delete downloadThread;
		downloadThread = NULL;
		ui->downloadButton->setText( QString::fromUtf8( "ダウンロード" ) );
		ui->downloadButton->setEnabled( true );
	}
	//ui->label->setText( "" );
	if ( Utility::nogui() )
		QCoreApplication::exit();
}
