## XMAIL型データのグラフ可視化及びグラフデータの編集ツール　一式
#### 国立九州大学プロジェクト

#### アプリケーション概要
XMAILデータをGraphDBに登録し、そのデータをnodeJS WEBアプリケーション上でデータ一覧、ペトリネット図を照会・編集するアプリケーションである。

#### 改訂履歴
|Author|Version|Last updated|Description|
|:-----:|:-----:|:-----:|:-----|
|Usk Tetsubayashi|1.0|2019/1/24|ドラフト|

#### リポジトリ構成
各コンポーネントの利用方法は個別のREADME.mdを参照のこと。

|Repository|Technology|
|:-----|:-----|
|graph-db|Neo4j|
|xmail-viewer|NodeJS|
|~~xmail-services~~|~~NodeJS~~|


#### サーバ起動手順

本アプリケーションは複数のDockerコンテナで構成されています。

|Repository|コンテナ|機能|
|:--|:--|:--|
|xmail-viewer|xmail_viewer|Webアプリケーション本体|
|graph-db|graph_db|Neo4jによるグラフDB|
|graph-db|graph_db_loader|XMAILデータロード（必要な時のみ実行）|


これら全てのコンテナは docker-compose によって一括管理されており、下記のようなコマンドを用いて一括して開始/終了の操作が可能です。

- コンテナ作成＆起動  
`docker-compose up -d`
- コンテナ停止  
`docker-compose stop`
- 停止中コンテナの起動  
`docker-compose start`
- コンテナ再起動  
`docker-compose restart`
- コンテナ終了＆イメージ削除  
`docker-compose down --rmi all`

例外として graph_db_loader の機能については上記操作では実行されず、下記のコマンドによって個別に実行します。
ロードするXMAILデータはコンテナ作成前にあらかじめ ./graph-db/XMAIL/ 以下に任意のフォルダ構成にて配置しておきます。
ファイル名は拡張子 '.xmail' または '.xml' が使用可能です。

- XMAILデータロード  
`docker-compose run --rm graph_db_loader sh setup.sh`


#### アプリケーション使用方法

下記URLへブラウザでアクセスする事によりアプリケーションのトップ画面が表示されます。

`http://＜ホスト名 or IPアドレス＞:3101`

※ローカル環境でのDocker machineの場合

[http://localhost:3101](http://localhost:3101)


#### その他ツール・スクリプト等

- XMAILデータロード(前項参照)  
`sh graph-db-loader.sh`
- XMAILデータ全削除  
`sh graph-db-delete.sh`


> Written with [StackEdit](https://stackedit.io/).
