#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#define CH1      0x01
#define CH2      0x02
#define CH3      0x04
#define CH4      0x08


/* EV3̃oCgR[h̒`̔łifrom bytecode.hj */
typedef enum
{
  opPROGRAM_STOP             = 0x02, //          0010
  opPROGRAM_START            = 0x03, //          0011

  opOUTPUT_GET_TYPE          = 0xA0, //          00000
  opOUTPUT_SET_TYPE          = 0xA1, //          00001
  opOUTPUT_RESET             = 0xA2, //          00010
  opOUTPUT_STOP              = 0xA3, //          00011
  opOUTPUT_POWER             = 0xA4, //          00100
  opOUTPUT_SPEED             = 0xA5, //          00101
  opOUTPUT_START             = 0xA6, //          00110
  opOUTPUT_POLARITY          = 0xA7, //          00111
  opOUTPUT_READ              = 0xA8, //          01000
  opOUTPUT_TEST              = 0xA9, //          01001
  opOUTPUT_READY             = 0xAA, //          01010
  opOUTPUT_POSITION          = 0xAB, //          01011
  opOUTPUT_STEP_POWER        = 0xAC, //          01100
  opOUTPUT_TIME_POWER        = 0xAD, //          01101
  opOUTPUT_STEP_SPEED        = 0xAE, //          01110
  opOUTPUT_TIME_SPEED        = 0xAF, //          01111

  opOUTPUT_STEP_SYNC         = 0xB0, //          10000
  opOUTPUT_TIME_SYNC         = 0xB1, //          10001
  opOUTPUT_CLR_COUNT         = 0xB2, //          10010
  opOUTPUT_GET_COUNT         = 0xB3, //          10011

  opOUTPUT_PRG_STOP          = 0xB4, //          10100
} OP;

int pwmfp;

int Stop(unsigned char ch)
{
        unsigned char Buf[4];
        int ret;

        Buf[0] = opOUTPUT_STOP;
        Buf[1] = ch;
        ret = write(pwmfp,Buf,2);
        return ret;
}

int PrgStart(void)
{
        unsigned char Buf[4];
        int ret;

        Buf[0] = opPROGRAM_START;
        ret = write(pwmfp,Buf,1);
        return ret;
}

int PrgStop(void)
{
        unsigned char Buf[4];
        int ret;
    
    Buf[0] = opPROGRAM_STOP;
        ret = write(pwmfp,Buf,1);
        return ret;
}


int Start(void)
{
        unsigned char Buf[4];
        int ret;

        Buf[0] = opOUTPUT_START;
        Buf[1] = CH1 | CH2 | CH3 | CH4;
        ret = write(pwmfp,Buf,2);
        return ret;
}

int Power(unsigned char ch, unsigned char power)
{
        unsigned char Buf[4];
        int ret;

        Buf[0] = opOUTPUT_POWER;
        Buf[1] = ch; /* CHw肷鎞 CH1 | CH2 Ƃ` */
        Buf[2] = power;
        ret = write(pwmfp,Buf,3);
        return ret;
}

int SetSpeed(unsigned char ch, unsigned char speed)
{
        
unsigned char Buf[4];
        int ret;

        Buf[0] = opOUTPUT_SPEED;
        Buf[1] = ch;
        Buf[1] = speed;
        ret = write(pwmfp,Buf,3);
        return ret;
}


int Reset(unsigned char ch)
{
        unsigned char Buf[4];
        int ret;

        Buf[0] = opOUTPUT_RESET;
        Buf[1] = ch;
        ret = write(pwmfp,Buf,2);
        return ret;
}

int main(void)
{

        pwmfp = open("/dev/lms_pwm",O_RDWR);
        if (pwmfp < 0) {
                printf("Cannot open dev/lms_pwm\n");
                exit(-1);
         }

        PrgStop();          /* PWM̐~܂B܂ȂiHj  */
        PrgStart();         /* PWM̃vOł̐Jn܂B */
        Reset(CH1|CH2|CH3|CH4);

        Start(); /* PWMɂ郂[^[Enableɂ܂ */
        printf("Start\n");
        sleep(2);

        Power(CH4, 30); /* Output CH4 ̃[^[30% ̃Xs[hœ܂B  */
        sleep(2);

        Power(CH4, 60); /* Output CH4 ̃[^[60% ̃Xs[hœ܂B  */
        sleep(2);

        Power(CH4, 100); /* Output CH4 ̃[^[100% ̃Xs[hœ܂B  */
        sleep(2);

        Power(CH4, 0); /* Output CH4 ̃[^[0% ̃Xs[hɂ~܂B  */
        sleep(2);

        Power(CH4, (unsigned char)-30); /* CH4̃[^[t30%̃Xs[hœ܂ */
        sleep(2);

        Power(CH4, (unsigned char)-60); /* CH4̃[^[t60%̃Xs[hœ܂ */
        sleep(2);

        Power(CH4, (unsigned char)-100); /* CH4̃[^[t100%̃Xs[hœ܂ */
        sleep(2);

        Power(CH4, 0); /* Output CH4 ̃[^[0% ̃Xs[hɂ~܂B  */
        sleep(2);

        Stop(CH4); /* PWM[^[̐~܂B̎_ł̓eV  */
        printf("STOP\n"); /* ԂŒ~Ă܂B                               */
        sleep(2);

        PrgStop(); /* PWM̏~܂B[^[Ɋ|ĂeV  */
        printf("ProgStop\n"); /* ܂B */

        return 1;
}
