
var path = require('path');
var fs = require('fs');
var config = require('../../config');

function findFigureFile(caption, imageDir) {
  var figId = caption.match(/^☆図([0-9]+-[0-9]+)/);
  var figName = 'fig' + figId[1] + '.fw.png';
  if (isExistsFigure(figName, imageDir)) {
    return figName;
  }
  return '';
}

function findImageFile(name, targetDir) {
  if (fs.existsSync(path.join(targetDir, name))) {
    return name;
  }
  var files = fs.readdirSync(targetDir);
  var exts = config.figureFormat;
  for (var i = 0; i < files.length; i++) {
    for (var j = 0; j < exts.length; j++) {
      var n = files[i].indexOf(name + exts[j]);
      if (n == 0) {
        return name + exts[j];
      }
    }
  }
  return '';
}

// split body-text and others
function splitBody(lines) {
  // split honmon and caption
  var counter = 0;
  var isCaption = false;

  var bodies = [];
  var captions = [];

  for (i = 0; i < lines.length; i++) {
    if (lines[i].match(/^＞＞＞＞/)) {
      captions.push(lines[i]);
      i++;
      while (!lines[i].match(/^＞＞＞＞/)) {
        captions.push(lines[i]);
        i++;
      }
      continue;
    }

    if (i >= lines.length) {
      break;
    }

    // cleanup blank line
    if (lines[i].match(/^\s+$/)) {
      lines[i] = '';
    }

    // end
    if ( lines[i] === ''
         && bodies.length > 0
         && bodies[bodies.length-1] === '' ) {
      // do nothing
    } else {
      // *図、*表を置換
      lines[i] = lines[i].replace(/\*図/g, '★図');
      lines[i] = lines[i].replace(/\*表/g, '★表');
      bodies.push(lines[i]);
    }
  }

  var result = {
    bodies: bodies,
    blockItems: captions
  }
  return result;
}

function createFigureList(lines, imageDir) {
  var figureList = [];
  var figMode = false;
  var currentFigure;

  for (var i = 0; i < lines.length; i++) {
    if (lines[i].match(/^＞＞＞＞/)) {
      figMode = false;
      continue;
    }

    if (lines[i].match(/^＝＝＝＝/)) {
      figMode = false;
      continue;
    }

    if (lines[i].match(/^☆図/)) {
      figMode = true;
      currentFigure = findFigureFile(lines[i], imageDir);
      if (currentFigure != '') {
        figureList.push(currentFigure);
      }
      continue;
    }

    if (figMode) {
      if (lines[i].match(/^\s*$/)) {
        continue;
      }
      var fullPath = findImageFile(lines[i], imageDir);
      figureList.push(fullPath);
      continue;
    }
  }
  return figureList;
}

function extractCaptions(lines, imageDir) {
  var captions = [];
  var figMode = false;
  var currentFigure;

  for (var i = 0; i < lines.length; i++) {
    if (lines[i].match(/^＞＞＞＞/)) {
      figMode = false;
      continue;
    }

    if (lines[i].match(/^＝＝＝＝/)) {
      figMode = false;
      captions.push('');
      continue;
    }

    if (lines[i].match(/^☆図/)) {
      captions.push('');
      captions.push(lines[i]);
      figMode = true;
      currentFigure = findFigureFile(lines[i], imageDir);
      /*
      if (currentFigure != '') {
        captions.push(currentFigure);
      }
      */
      continue;
    }

    if (figMode) {
      if (currentFigure != '') {
        continue;
      }
      if (lines[i].match(/^\s*$/)) {
        continue;
      }
      var fullPath = findImageFile(lines[i], imageDir);
      /*
      captions.push(fullPath);
      */
      continue;
    }
    captions.push(lines[i]);
  }
  return captions;
}

function isExistsFigure(figName, targetDir) {
  var fullPath = path.join(targetDir, figName);
  return fs.existsSync(fullPath);
}

function makeHtmls(lines, imageDir) {
  var html = [];
  var figMode = false;
  var figTextMode = false;
  var assumedFigName;
  var figName
  var figId;
  for (var i = 0; i < lines.length; i++) {

    if (lines[i].match(/^＞＞＞＞/)) {
      figMode = false;
      continue;
    }

    // figure
    if (lines[i].match(/^☆図/)) {
      figId = lines[i].match(/^☆図([0-9]+-[0-9]+)/);
      console.log(lines[i]);
      assumedFigName = 'fig' + figId[1] + '.fw.png';
      figMode = true;
      if (isExistsFigure(assumedFigName, imageDir)) {
        html.push('<span class="caption">' + lines[i] + '</span>');
        html.push('<img src="figures/' + assumedFigName + '">');
        html.push('<span class="filename">' + assumedFigName + '</span>');
        i++;
        while((i < lines.length) && (!lines[i].match(/^＞＞＞＞/))) {
          if (lines[i].match(/^\s*$/)) {
            i++;
            continue;
          }
          if (lines[i].match(/^＝＝＝＝/)) {
            figMode = false;
          }
          if (figMode) {
            figName = findImageFile(lines[i], imageDir);
            if ((figName != '') && (figName != assumedFigName)) {
              html.push('<span class="filename">' + figName + '</span>');
            }
          }
          i++;
        }
        continue;
      }
      figMode = true;
      html.push('<span class="caption">' + lines[i] + '</span>');
      continue;
    }

    if (lines[i].match(/^＝＝＝＝/)) {
      i++;
      while(!lines[i].match(/^＞＞＞＞/)) {
        i++;
      }
      continue;
    }

    // figure mode
    if (figMode) {
      if (lines[i].match(/^\s*$/)) {
        continue;
      }
      figName = findImageFile(lines[i], imageDir);
      if (figName != '') {
        html.push('<img src="figures/' + figName + '">');
        html.push('<span class="filename">' + figName + '</span>');
      }
      continue;
    }

    // table 
    if (lines[i].match(/^☆表/)) {
      html.push('<span class="caption">' + lines[i] + '</span>');
      html.push('<table>');
      i++;
      while((i < lines.length) && (!lines[i].match(/^\s*$/))) {
        if (lines[i].match(/^＞＞＞＞/)) {
          break;
        }
        html.push(lines[i].replace(/^/, '<tr><td>')
                  .replace(/$/, '</td></tr>')
                  .replace(/\t/g, '</td><td>'));
        i++;
      }
      html.push('</table>');
      continue;
    }

    // others
    html.push(lines[i]);
  }
  return html;
}

// parse main text to separate body text and captions/tables
function parseText(data, target) {
  var lines = data.split('\n');
  var targetDir = path.dirname(target);
  var imageDir = path.join(targetDir, 'figure');

  // split body and others
  // result.bodies:
  // result.blockItems: 
  var result = splitBody(lines);

  // generate captions
  result.captions = extractCaptions(result.blockItems, imageDir)

  // generate htmls
  result.htmls = makeHtmls(result.blockItems, imageDir);

  // generate Figure List
  result.figures = createFigureList(result.blockItems, imageDir);

  return result;
}

var exportParser = {};
exportParser.parseText = parseText;
module.exports = exportParser;

