// export.js
/*
 * usage:
 * node export.js <target directory> <output directory>
 */

var config = require('../../config');
var path = require('path');
var fs = require('fs');
var util = require('util');

var tocParser = require('./toc-parser');
var exportSinge = require('./export-single');

var usage = 'node export.js <target directory> <output directory>';

function exportPages(taget, output) {
  var toc = readToc(target);
  if (toc.directories[target] === undefined) {
    process.stderr.write('target not fonund.\n');
    exit(-1);
  }
  var chapter = toc.directories[target].chapter;
  var contents = toc.directories[target].contents;
  var page = toc.directories[target].pageStart;

  //console.log(toc.directories[target]);
  contents.forEach(function (content) {
    var pageStart = page;
    var pageCount = content.pages;
    var outputDirPath = calcOutputDirPath(content, page);
    page += content.pages;
    var targetPathname = path.join(config.rootDir, target, content.title + '.txt');
    //console.log(targetPathname, outputDirPath);
    exportSinge(targetPathname, outputDirPath, chapter, pageStart, pageCount);
  });
}

function calcOutputDirPath(content, page) {
  if (content.pages == 1) {
    var outputFileName = util.format('p%s',
                                     padNumber(page));
  } else {
    var outputFileName = util.format('p%s-%s',
                                     padNumber(page),
                                     padNumber(page + content.pages - 1));
  }
  return path.join(output, outputFileName);
}

function padNumber(num) {
  if (num < 10) {
    return '00' + String(num);
  }
  if (num < 100) {
    return '0' + String(num);
  }
  return num;
}

function readToc(target) {
  var tocPath = path.join(config.rootDir, 'index.toc');
  var text = fs.readFileSync(tocPath, {encoding: 'utf8'});
  var toc = tocParser.parseToc(text);
  return toc;
}

// main action
if (require.main == module) {
  if (process.argv.length < 4) {
    process.stdout.write(usage + '\n');
    process.exit(1);
  }
  var target = process.argv[2];
  var output = process.argv[3];
  exportPages(target, output);
}
