/* text2html.js */

var util = require('util');

var formatters = require('./formatters');
var text2html = {};

text2html.formatText = function formatText(text) {
  var lines = text.split('\n');
  var modeFlags = {};
  var modes = formatters.modes;

  for (var i = 0; i < lines.length; i++) {
    var currentLine = lines[i];

    for (var j = 0; j < modes.length; j++ ) {
      var mode = modes[j];
      if (mode.flag) {
        if (mode.exit.test(currentLine)) {
          currentLine = mode.exit.action(currentLine) + '\n';
          mode.flag = false;
        } else if (mode.action) {
          currentLine = mode.action(currentLine);
        } else {
          currentLine = formatters.markupInline(currentLine);
        }
        break;
      } else {
        if (mode.enter.test(currentLine)) {
          currentLine = mode.enter.action(currentLine);
          mode.flag = true;
          break;
        }
      }
    }

    lines[i] = currentLine;
  }
  return lines;
};

module.exports = text2html;


if (require.main == module) {
  // This file directly executed by node command
  var buf = '';
  process.stdin.setEncoding('utf8');

  process.stdin.on('readable', function () {
    var chunk = process.stdin.read();
    if (chunk !== null) {
      buf += chunk;
    }
  });

  process.stdin.on('end', function () {
    var lines = text2html.formatText(buf);
    for (var i = 0; i < lines.length; i++) {
      process.stdout.write(lines[i]);
      process.stdout.write('\n');
    }
  });
}
