﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using NationalInstruments.NI4882;


namespace SpiderNet {
    /// <summary>
    /// NewScope.xaml の相互作用ロジック
    /// </summary>
    public partial class NewScopeForm : Window {
	
		private byte[] PrimaryAddressArray;
		private byte[] SecondaryAddressArray;
		private Device NewDevice;

        public NewScopeForm(DeviceListClass GPIBDeviceList) {

            InitializeComponent();
			System.Resources.ResourceManager rm =
			new System.Resources.ResourceManager("SpiderNet.Properties.Resources", typeof(NewScopeForm).Assembly);
			Title = rm.GetString("UINewScopeWindowTitle");

			PrimaryAddressArray = new byte[GPIBDeviceList.NumFreeDevice()];
			SecondaryAddressArray = new byte[GPIBDeviceList.NumFreeDevice()];

            try {
				DeviceListBox.Items.Clear();
                for (int Index = 0; Index < GPIBDeviceList.NumFreeDevice(); Index++) {
					PrimaryAddressArray[Index] = GPIBDeviceList.FreeDevicePrimaryAddress(Index);
					SecondaryAddressArray[Index] = GPIBDeviceList.FreeDeviceSecondaryAddress(Index);
					Device GPIBDevice = new Device(0, PrimaryAddressArray[Index], SecondaryAddressArray[Index] );
					GPIBDevice.Write("*IDN?");
					string IDString = GPIBDevice.ReadString();
                    string ModelString = GetID(IDString);
					string DisplayString = ModelString + "(" + GPIBDevice.PrimaryAddress.ToString() + ")";
					DeviceListBox.Items.Add(DisplayString);
					GPIBDevice.GoToLocal();
					GPIBDevice.Dispose();
                }
            }
            catch (NationalInstruments.NI4882.GpibException Ex) {
				ErrorDialog DialogForm = new ErrorDialog(Ex);
            }
            catch (Exception Ex) {
				ErrorDialog DialogForm = new ErrorDialog(Ex);
            }
        }

		public Device CreatedDevice(){
			return(NewDevice);
		}

		private void GenerateNewScopeButton_Click(object sender, RoutedEventArgs e) {
			if (DeviceListBox.SelectedIndex != -1) {
				int SelectedIndex = DeviceListBox.SelectedIndex;
				NewDevice = new Device(0, PrimaryAddressArray[SelectedIndex] ,
					SecondaryAddressArray[SelectedIndex]);
				DialogResult = true;
			} else {
				DialogResult = false;
			}
			Close();
		}

		private void CancelNewScopeButton_Click(object sender, RoutedEventArgs e) {
			DialogResult = false;
			Close();

		}

		private string GetID(string IDNString){
			if(IDNString.Contains("YOKOGAWA")){
				if(IDNString.IndexOf("7015") == 9){ // YOKOGAWA's DL1500 series returns YOKOGAWA,7015XX 
                    return "YOKOGAWA DL1500";
				}
				if (IDNString.IndexOf("7016") == 9) { // YOKOGAWA's DL1600 series returns YOKOGAWA,7016XX 
                    return "YOKOGAWA DL1600";
                }
				if (IDNString.IndexOf("7017") == 9) { // YOKOGAWA's DL1700 series returns YOKOGAWA,7017XX 
                    return "YOKOGAWA DL1700";
                }
				if (IDNString.IndexOf("7101") == 9) { // YOKOGAWA's DL2000 series returns YOKOGAWA,7101XX 
                    return "YOKOGAWA DL2000";
                }
				if (IDNString.IndexOf("DL750") == 9) { // YOKOGAWA's DL750 series returns YOKOGAWA,DL750XX 
					return "YOKOGAWA DL750";
				}

			}
			if(IDNString.Contains("LECROY")){
                return "LECROY";
			}
            return "Unknown";
		}
    }
}
