﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using NationalInstruments.NI4882;


namespace SpiderNet
{
	/// <summary>
	/// ErrorDialog.xaml の相互作用ロジック
	/// </summary>
	public partial class ErrorDialog : Window
	{

		public ErrorDialog(System.Exception Ex)
		{
			System.Resources.ResourceManager rm = 
			new System.Resources.ResourceManager("SpiderNet.Properties.Resources", typeof(WarningDialog).Assembly);

			if(Ex is NationalInstruments.NI4882.GpibException){
				DialogText.Content = rm.GetString("UIMessageGPIBError");
			} else { if (Ex is System.DllNotFoundException) {
					DialogText.Content = rm.GetString("UIMessageDLLNotFund");
				} else { if (Ex is System.EntryPointNotFoundException) {
						DialogText.Content = rm.GetString("UIMessageEntryPointNotFound");
					} else { if (Ex is System.ObjectDisposedException) {
							DialogText.Content = rm.GetString("UIMessageDisposedException");
						} else { if (Ex is System.InvalidOperationException) {
								DialogText.Content = rm.GetString("UIMessageInvalidOperation");
							} else { if (Ex is System.Exception) {
									DialogText.Content = rm.GetString("UIMessageSystemError");
								}
							}
						}
					}
				}
			}
			DialogText.Content += "\r\n" + Ex.ToString();
			
			ShowDialog();

		}

		public ErrorDialog(string MessageIDString) {
			InitializeComponent();
			System.Resources.ResourceManager rm =
			new System.Resources.ResourceManager("SpiderNet.Properties.Resources", typeof(WarningDialog).Assembly);
			DialogText.Content = rm.GetString(MessageIDString);

			ShowDialog();
		}

		private void Button_Click(object sender, RoutedEventArgs e)
		{
			DialogResult = true;
			Close();
		}
	}
}
