﻿/*@@@*
The MIT License (MIT)

Copyright (c) 2013 GMA0BN

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
**@@@*/
#include "stdafx.h"
#include "sockutil.h"

/// セッションのリソースを初期化します。
void init_session_res(void* pRes, size_t size, size_t cnt)
{
    size_t i;
    char* wp;
    SessionRes* p;

    wp = (char*)pRes;
    for (i = 0; i < cnt; ++i) {
        p = (SessionRes*)wp;
        p->socket = INVALID_SOCKET;
        p->hThread = NULL;
        wp += size;
    }
}

/// セッションのリソースを開放します。
BOOL release_session_res(void* pRes, size_t size, size_t cnt, BOOL bFull)
{
    size_t i, idx, wcnt;
    HANDLE ahActiveThreads[MAXIMUM_WAIT_OBJECTS];
    int anIndices[MAXIMUM_WAIT_OBJECTS];
    DWORD dwRet;
    char* wp;
    SessionRes* p;

    for (;;) {
        // アクティブなスレッドを列挙
        wp = (char*)pRes;
        wcnt = 0;
        for (i = 0; i < cnt && wcnt < MAXIMUM_WAIT_OBJECTS; ++i) {
            p = (SessionRes*)wp;
            if (p->hThread != NULL) {
                if (bFull || p->socket == INVALID_SOCKET) {
                    ahActiveThreads[wcnt] = p->hThread;
                    anIndices[wcnt] = i;
                    ++wcnt;
                }
                /*= !bFullのときは、セッション継続中のCBを待ちの対象にしない。
                 *  セッション継続中か否かはp->socket != INVALID_SOCKET
                 *  か否かで判定できる前提。
                 */
            }
            wp += size;
        }
        if (wcnt <= 0) break;       // 全スレッド終了

        // スレッド終了を待つ
        assert(wcnt <= MAXIMUM_WAIT_OBJECTS);
        dwRet = WaitForMultipleObjects(wcnt, ahActiveThreads, TRUE, INFINITE);
        if (!(WAIT_OBJECT_0 <= dwRet && dwRet < WAIT_OBJECT_0 + wcnt)) {
            DWORD err = GetLastError();
            fprintf(stderr, "\nERROR: " __FUNCTION__ ": WaitForMultipleObjects() failed. (err=0x%08lx)\n", err);
            return FALSE;
        }

        // リソース開放
        for (i = 0; i < wcnt; ++i) {
            idx = anIndices[i];
            p = (SessionRes*)((char*)pRes + size * idx);
            assert(p->hThread == ahActiveThreads[i]);
            assert(p->socket == INVALID_SOCKET);    // スレッド終了時にソケットはclose済みのはず
            CloseHandle(p->hThread);    // スレッドオブジェクト開放
            p->hThread = NULL;          // スレッド終了を記録
        }
    }

    return TRUE;
}

/// 空いているCBを取得します。
int get_new_session_cb(void* pRes, size_t size, size_t cnt, size_t sta)
{
    size_t i, idx;
    SessionRes* p;

    for (i = 0; i < cnt; ++i) {
        idx = sta + i;
        if (idx >= cnt) idx -= cnt;
        assert(idx < cnt);

        p = (SessionRes*)((char*)pRes + size * idx);
        if (p->hThread == NULL) {
            return idx;
        }
    }

    return -1;
}
