#include "stdafx.h"
#include "VreathItem.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TractorMagic.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/ggaf/core/util/GgafStatus.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

VreathItem::VreathItem(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat)
               : Item(prm_name, prm_model, prm_pStat) {
    _class_name = "VreathItem";
    pAxsMver_ = NEW GgafDxAxesMover(this);
    effectBlendOne(); //ZTechniquew
    setZEnable(true);        //Zobt@͍lL
    setZWriteEnable(false);  //Zobt@͏ݖ
    setAlpha(0.9);
    GgafDxKuroko* pKuroko = getKuroko();
    pKuroko->setFaceAngVelo(D_ANG(3), D_ANG(5), D_ANG(7));
    pKuroko->relateFaceByMvAng(true);
    kDX_ = kDY_ = kDZ_ = 0;
    useProgress(PROG_BANPEI);
    setHitAble(true, false); //ʊO蔻͖
    CollisionChecker3D* pChecker = getCollisionChecker();
    pChecker->makeCollision(1);
    pChecker->setColliAAB_Cube(0, 400000);
    GgafDxSeTransmitterForActor* pSeTx = getSeTx();
    pSeTx->set(0, "WAVE_GET_ITEM_001");
}

void VreathItem::initialize() {
}

void VreathItem::onActive() {
    // _x, _y, _z ͔Wɐݒς
    setHitAble(true, false);

    pAxsMver_->forceVxyzMvVeloRange(-30000, 30000);
    pAxsMver_->setZeroVxyzMvVelo();
    pAxsMver_->setZeroVxyzMvAcce();
    pAxsMver_->stopGravitationMvSequence();

    //ݒ
    MyShip* pMyShip = P_MYSHIP;
//    //U΂͈͐`Pӂ̒
//    int scattered_renge    = pChecker->_pCollisionArea->_papColliPart[0]->_dx; //蔻Ɠ
//    //n_A@ւ̕ւ̎U΂͈͐`̈悪ʒu鋗iscattered_distance > (scattered_renge/2) ł邱)
////    int scattered_distance = scattered_renge/2 + 400000;
//    //]āAscattered_distance ĂĂA@͓ȂĂ肬SĉłB
    GgafDxKuroko* pKuroko = getKuroko();
    pKuroko->forceMvVeloRange(0, 20000);
    float vX, vY, vZ;
    UTIL::getNormalizeVector(
            pMyShip->_x - _x,
            pMyShip->_y - _y,
            pMyShip->_z - _z,
            vX, vY, vZ);
    int d = PX_C(200);
    int r = PX_C(75);
    pKuroko->setMvAngTwd( (coord)(_x + (vX * d) + RND(-r, +r)),
                          (coord)(_y + (vY * d) + RND(-r, +r)),
                          (coord)(_z + (vZ * d) + RND(-r, +r)) );
    pKuroko->setMvVelo(2000);
    pKuroko->setMvAcce(100);

    getProgress()->reset(PROG_DRIFT);
    _sx = _sy = _sz = 1000;
}

void VreathItem::processBehavior() {
    //ʏړ
    GgafDxKuroko* pKuroko = getKuroko();
    GgafProgress* pProg = getProgress();
    if (pProg->get() == PROG_DRIFT) {
        //TractorMagicPROG_ATTACHֈڍs
        if (getTractorMagic()->is_tracting_) {
            effectFlush(6); //tbV
            setHitAble(false);
            pProg->change(PROG_ATTACH);
        }
        //邢 onHit()  PROG_ATTACH ԕω̂҂
    }

    //@Ɠ蔻肪qbgA@Ɍ
    if (pProg->get() == PROG_ATTACH) {
        MyShip* pMyShip = P_MYSHIP;
        if (pProg->isJustChanged()) {
            //@Ɉ͂ň񂹂悤ȓݒ
            pAxsMver_->setVxyzMvVelo(pKuroko->_vX * pKuroko->_veloMv,
                                     pKuroko->_vY * pKuroko->_veloMv,
                                     pKuroko->_vZ * pKuroko->_veloMv );
            pAxsMver_->execGravitationMvSequenceTwd(pMyShip, PX_C(20), 200, PX_C(100));
            pKuroko->stopMv();
        }

        //@ߕӂɓBH
        if (ABS(pMyShip->_x - _x) < 20000 &&
            ABS(pMyShip->_y - _y) < 20000 &&
            ABS(pMyShip->_z - _z) < 20000 ) {

            kDX_ = pMyShip->_x - _x;
            kDY_ = pMyShip->_y - _y;
            kDZ_ = pMyShip->_z - _z;
            pProg->change(PROG_ABSORB); //zz
        }

    }

    //@ߕӂɓBAzAz̓
    if (pProg->get() == PROG_ABSORB) {
        MyShip* pMyShip = P_MYSHIP;
        if (pProg->isJustChanged()) {
            pAxsMver_->setZeroVxyzMvVelo();
            pAxsMver_->setZeroVxyzMvAcce();
            pAxsMver_->stopGravitationMvSequence();
        }
        _x = pMyShip->_x + kDX_;
        _y = pMyShip->_y + kDY_;
        _z = pMyShip->_z + kDZ_;
        _sx -= 100;
        _sy -= 100;
        _sz -= 100;
        if (_sx < 5) {
            getSeTx()->play(0);
            pProg->changeNothing();
            sayonara(); //I
        }
        pMyShip->getStatus()->plus(STAT_Stamina, 1);
    }
    pKuroko->behave();
    pAxsMver_->behave();
}

void VreathItem::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
//    //ʏړ
//    if (pProg->get() == PROG_DRIFT) {
//        //onHit() ŏԕω̂҂
//    }
//
//    //@Ɠ蔻肪qbg
//    if (pProg->get() == PROG_ATTACH) {
//
//    }
//
//    //@ɋzAz̓
//    if (pProg->get() == PROG_ABSORB) {
//    }
}

void VreathItem::onInactive() {
}

void VreathItem::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg

    GgafProgress* pProg = getProgress();
    if (pProg->get() == PROG_DRIFT && (pOther->getKind() & KIND_MY_BODY))  {
        setHitAble(false);
        pProg->change(PROG_ATTACH);
    }
}

VreathItem::~VreathItem() {
    GGAF_DELETE(pAxsMver_);
}

