#include "stdafx.h"
#include "EnemyOmulus.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpher.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

#define MORPHTARGET_HATCH_OPEN 1

EnemyOmulus::EnemyOmulus(const char* prm_name) :
        DefaultMorphMeshActor(prm_name, "1/Omulus", STATUS(EnemyOmulus)) {
    _class_name = "EnemyOmulus";
    pScaler_ = NEW GgafDxScaler(this);
    is_open_hatch_ = false;
    frame_of_open_interval_  = 3*60;
    frame_of_close_interval_ = 20*60;
    frame_of_morph_interval_ = 120;

    pDepo_Fired_ = nullptr;
    pDepoConnection_ = connect_DepositoryManager("Talante");
    GgafDxSeTransmitterForActor* pSeTx = getSeTx();
    pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");
    useProgress(PROG_BANPEI);
}

void EnemyOmulus::onCreateModel() {
    GgafDxModel* pModel = getModel();
    pModel->setBlinkPower(0.1, 0.9);
    pModel->getTexBlinker()->forceRange(0.1, 1.0);
    pModel->getTexBlinker()->beat(120, 60, 0, 60, -1);
    pModel->setSpecular(5.0, 1.0);
}

void EnemyOmulus::initialize() {
    setHitAble(true);
    getKuroko()->relateFaceByMvAng(true);
    getMorpher()->forceRange(MORPHTARGET_HATCH_OPEN, 0.0f, 1.0f);
    setMorphWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    CollisionChecker3D* pChecker = getCollisionChecker();
    pChecker->makeCollision(1);
    pChecker->setColliAAB_Cube(0, 200000);
    setScale(1000);
    pScaler_->forceRange(1000, 1200);
    pScaler_->beat(30, 5, 0, 20, -1);
    pDepo_Fired_ = pDepoConnection_->peek();
}

void EnemyOmulus::onActive() {
    getStatus()->reset();
    setMorphWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    is_open_hatch_ = false;
//    frame_of_moment_nextopen_ = frame_of_close_interval_;
    getProgress()->reset(PROG_HATCH_CLOSE);
}

void EnemyOmulus::processBehavior() {
    //[JŌvZs
    changeGeoLocal();

    //{[ɂAN^[̃
    //_x, _y, _z, _rx, _ry, _rz ɂĂQ̍WnZbg؂ւKvȎdlłB
    //ꂼꃍ[JWAŏIi΁jWƌĂԂƂɂ܂B
    //EŏIi΁jW EEE ʂ̃[hWn̎łB
    //E[JW     EEE eAN^[̊_(0,0,0)̑ΓIȍWnӖ܂B
    //                          WvZ͂ōsĉB
    //j
    //  @WvZ͎Ƀ[JWňvZłBGgafDxKuroko Ń[JWn̑sƂƂB
    //    AWؓo^A蔻A^[QbgWȂǁÃIuWFNg烏[hWQƂ铙A
    //    {Ԃ͍ŏIi΁jWnB
    //    processBehavior()Jn ŏIi΁jWn(changeGeoFinal())̏ԂƂȂĂB
    //  AprocessBehavior()ŕKvɉ changeGeoLocal() Ńo[ _x, _y, _z, _rx, _ry, _rz [JWn
    //    ؂ւ邱Ƃ\Bړ̍WvZsB
    //  BA processBehavior() 𔲂ۂɂ͕KŏIW(changeGeoFinal())̏Ԃɖ߂ĂB
    //  CŏIi΁jWƁA[JW݂͌ɓƗA͂ȂA
    //    \̃[hϊs쐬AsςōAŏIIȕ\ʒu肷B

    //changeGeoLocal(); s
    //[JWnɐؑւ܂B
    //E_x, _y, _z     EEE ́A[JWӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_x, _y, _z 
    //                        [JWlɐ؂ւ܂B
    //E_rx, _ry, _rz  EEE ́A[JWł̎]lӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_rx, _ry, _rz
    //                        [JW]lɐ؂ւ܂B

    //changeGeoFinal(); s
    //ŏIi΁jWnɐ؂ւ܂B
    //E_x, _y, _z    EEE t[ GgafDxGeometricActor::processSettlementBehavior() ŌvZꎩXVĂ܂B
    //                       processBehavior()  changeGeoFinal() sƁAPt[O_x, _y, _zɐ؂ւ鎖ɂȂ܂B
    //                       _x, _y, _z ͎QƐpBlĂӖL܂
    //E_rx, _ry, _rz EEE t[ GgafDxGeometricActor::processSettlementBehavior() ܂I
    //                       changeGeoFinal(); sĂA_rx, _ry, _rz ͈ȑO̍ŏIi΁jWn̒l
    //                       ςȂŕω܂B
    //                       ̃IuWFNgA{[ɂAN^[QƂƂA_rx, _ry, _rz͑SMpł܂B

    //Ӂ
    //EGgafDxKuroko(getKuroko()) behave() ȊO\bh́AɃ[JW̑ƂB
    //  behave()ȊO\bh͎ۂɍWvZĂ킯ł͂Ȃ̂ŁA
    //  changeGeoFinal()AchangeGeoLocal()Ɋ֌WȂAĂяo\B
    //EGgafDxKuroko(getKuroko()) behave() \bh͍WPt[̏ԂɂvZsB
    //  āÂ悤 [JW(changeGeoLocal())ŌĂяoƂB
    //    changeGeoLocal();
    //    pKuroko->behave();
    //    changeGeoFinal();
    //TODO:݊ƂȂB
    GgafDxKuroko* pKuroko = getKuroko();
    GgafProgress* pProg = getProgress();
    switch (pProg->get()) {
        case PROG_INIT: {
            pProg->change(PROG_HATCH_CLOSE);
            break;
        }
        case PROG_HATCH_CLOSE: {
            if (pProg->isJustChanged()) {
                getMorpher()->transitionLinerUntil(MORPHTARGET_HATCH_OPEN,
                                                0.0f, frame_of_morph_interval_);
                pKuroko->setFaceAngVelo(AXIS_X, -3000);
            }

            //
            if (pProg->getFrameInProgress() >= frame_of_close_interval_ + frame_of_morph_interval_) {
                pProg->change(PROG_HATCH_OPEN);
            }
            break;
        }
        case PROG_HATCH_OPEN: {
            if (pProg->isJustChanged()) {
                getMorpher()->transitionLinerUntil(MORPHTARGET_HATCH_OPEN,
                                           1.0f, frame_of_morph_interval_);
                pKuroko->setFaceAngVelo(AXIS_X, 0);
            }
            //processJudgement()ŃVbg
            if (pProg->getFrameInProgress() >= frame_of_open_interval_+ frame_of_morph_interval_) {
                pProg->change(PROG_HATCH_CLOSE);
            }
            break;
        }
        default :
            break;
    }
    //ZN|Cg
    UTIL::updateEnemyRankPoint(this);

//    if (getActiveFrame() % 10U == 0                   && 1 == 2) {
//        //@֕
//        //lF[JWnŗ\߂ǂ̕ɌĂ΁AŏIIɎ@ɌƂɂȂ邩߂
//        //
//        //@ւ̌߂̕ϊOԂł̃^[Qbgʒu(tvx, tvy, tvz) ƂA
//        //uy܂Łv̍s̐ρi_pActor_Base->_matWorldRotMv)  b_mat_xx ƂB
//        //݂̍ŏIW玩@ւ̌̃xNgA(mvx, mvy, mvz) ƂƁA
//        //
//        //                | b_mat_11 b_mat_12 b_mat_13 |
//        //| tvx tvy tvz | | b_mat_21 b_mat_22 b_mat_23 | = | mvx mvy mvz |
//        //                | b_mat_31 b_mat_32 b_mat_33 |
//        //
//        //ƂȂB[JW(tvx, tvy, tvz) ̕ƁA
//        //ŏIIɎ@ɌƂɂȂB
//        //ts|(tvx, tvy, tvz) ߂Ηǂ
//        //
//        //                                   | b_mat_11 b_mat_12 b_mat_13 | -1
//        // | tvx tvy tvz | = | mvx mvy mvz | | b_mat_21 b_mat_22 b_mat_23 |
//        //                                   | b_mat_31 b_mat_32 b_mat_33 |
//        //
//
//        //mvx mvy mvz ߂
//        int mvx = P_MYSHIP->_x - _x;
//        int mvy = P_MYSHIP->_y - _y;
//        int mvz = P_MYSHIP->_z - _z;
//        //ts擾
//        D3DXMATRIX* pBaseInvMatRM = getBaseActor()->getInvMatWorldRotMv();
//        //[JWł̃^[QbgƂȂxNgvZ
//        int tvx = mvx*pBaseInvMatRM->_11 + mvy*pBaseInvMatRM->_21 + mvz * pBaseInvMatRM->_31;
//        int tvy = mvx*pBaseInvMatRM->_12 + mvy*pBaseInvMatRM->_22 + mvz * pBaseInvMatRM->_32;
//        int tvz = mvx*pBaseInvMatRM->_13 + mvy*pBaseInvMatRM->_23 + mvz * pBaseInvMatRM->_33;
//        //V[NGXJn
//        angle angRz_Target, angRy_Target;
//        UTIL::convVectorToRzRy(tvx, tvy, tvz, angRz_Target, angRy_Target);
//        pKuroko->turnRzRyMvAngTo(angRz_Target, angRy_Target,
//                                   1000, 0,
//                                   TURN_CLOSE_TO, false);
//    }

    pScaler_->behave();
    getMorpher()->behave();

    pKuroko->behave();
    changeGeoFinal();
}

void EnemyOmulus::processJudgement() {
    //΍WXVĂ`
    GgafProgress* pProg = getProgress();
    switch (pProg->get()) {
        case PROG_HATCH_OPEN: {
            //I[vGo
            if (getMorphWeight(MORPHTARGET_HATCH_OPEN) > 0.5) { //[Vȏ܂œBȂ
                if (pProg->getFrameInProgress() % (frame)(RF_EnemyOmulus_ShotInterval(G_RANK)) == 0) { //oԊu
                    if (pDepo_Fired_) {
                        GgafDxDrawableActor* pActor = (GgafDxDrawableActor*)pDepo_Fired_->dispatch();
                        if (pActor) {
                            pActor->getKuroko()->setRzRyMvAng(_rz, _ry); //΍Wnł̌
                            pActor->position(_x, _y, _z);
                            pActor->reset();
                        }
                    }
                }
            }
            break;
        }
        default :
            break;
    }


    if (getBaseActor() && getBaseActor()->isActiveInTheTree()) {
//        (*(_pActor_Base->_pFunc_calcRotMvWorldMatrix))(_pActor_Base, _matWorld);
    } else {
        //y䂪ȂΎ
        sayonara();
    }


//    if (isOutOfUniverse()) {
//        sayonara();
//    }
}

void EnemyOmulus::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        getSeTx()->play3D(SE_EXPLOSION);
    } else {
        //j
        getSeTx()->play3D(SE_DAMAGED);
    }
}

void EnemyOmulus::onInactive() {
    sayonara();
}

EnemyOmulus::~EnemyOmulus() {
    pDepoConnection_->close();
    GGAF_DELETE(pScaler_);
}
