#include "stdafx.h"
#include "EnemyErmioneArmHead.h"
#include "EnemyErmione.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/ggaf/lib/actor/laserchip/StraightLaserChip.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyErmioneArmHead::EnemyErmioneArmHead(const char* prm_name) :
        EnemyErmioneArm(prm_name, "ErmioneArmHead", STATUS(EnemyErmioneArmHead)) {
    _class_name = "EnemyErmioneArmHead";
    pDepoLaser_  = nullptr;
}

void EnemyErmioneArmHead::onCreateModel() {
}

void EnemyErmioneArmHead::initialize() {
    EnemyErmioneArm::initialize();
    CollisionChecker3D* pChecker = getCollisionChecker();
    pChecker->makeCollision(1);
    pChecker->setColliAAB_Cube(0, 40000);
}

void EnemyErmioneArmHead::processBehavior() {
    GgafProgress* pProg = getProgress();
    if (pProg->get() == PROG_NOTHING || pProg->get() == PROG_AIMING) { //oԊu
        if (!pDepoLaser_) {
            pDepoLaser_ = (LaserChipDepository*)UTIL::getDepositoryOf(this);
        }
    } else {
        pDepoLaser_ = nullptr;
    }

    EnemyErmioneArm::processBehavior();
}

void  EnemyErmioneArmHead::processJudgement() {
    LaserChip* pChip = nullptr;
    if (pDepoLaser_) {
        pChip = pDepoLaser_->dispatch();
        if (pChip) {
            //DEPO_LASER001̏ꍇ
            pChip->setFaceAng(_rx, _ry, _rz);
            pChip->getKuroko()->setRzRyMvAng(_rz, _ry); //΍Wn
            pChip->positionAs(this);

            //DEPO_LASER002̏ꍇ
            //((StraightLaserChip*)pChip)->setSource(this);
        }
    }
}

void EnemyErmioneArmHead::onHit(GgafActor* prm_pOtherActor) {



    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
//    if (UTIL::calcEnemyStamina(this, pOther) <= 0) {
//        setHitAble(false);
//        //
//        UTIL::activateExplosionEffectOf(this);
//        getSeTx()->play3D(SE_EXPLOSION);
//
//        //@Ɍďł̏ꍇA
//        if (pOther->getKind() & KIND_MY) {
//            //ACeo
//            UTIL::activateItemOf(this);
//        }
//        sayonara();
//    } else {
//        //j
//        effectFlush(2); //tbV
//        getSeTx()->play3D(SE_DAMAGED);
//    }
}


EnemyErmioneArmHead::~EnemyErmioneArmHead() {
//    pDepoConnection_->close();
}
