#ifndef CAMERA_H_
#define CAMERA_H_
#include "jp/ggaf/lib/actor/DefaultCamera.h"

namespace VioletVreath {

/**
 * J.
 * @version 1.00
 * @since 2010/10/22
 * @author Masatoshi Tsuge
 */
class Camera : public GgafLib::DefaultCamera {

    coord tx_, ty_, tz_;

    static int cnvVec2FaceNo(float vx, float vy, float vz);
    static void cnvFaceNo2Vec(int face_no, float& out_vx, float& out_vy, float& out_vz);

public:

    enum {
        FACE_FRONT = 1,
        FACE_BEHIND = 6,
        FACE_TOP = 2,
        FACE_BOTTOM = 5,
        FACE_ZLEFT = 3,
        FACE_ZRIGHT = 4,
    };

    int up_face_;
    /** [r]JxNg˂hʔԍ */
    int vcv_face_;
    /** [r]JxNg˂hʔԍ */
    int vcv_face_prev_;

    /** sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_;

    /** [r]JUPxNgɃRs[ēxNgW̃AN^[ */
    GgafLib::DefaultGeometricActor* pUp_;
    /** [r]pUp_炩Ɉړ邽߂̃wp[ */
    GgafDxCore::GgafDxAxesMover* pAxsMver_Up_;

    Camera(const char* prm_name);

    GgafDxCore::GgafDxCameraViewPoint* createViewPoint() override;

    virtual void initialize() override;

    virtual void processBehavior() override;

    /**
     * J_xNg̖ʔԍ擾܂ .
     * @return J_xNg̖ʔԍ(1`6)
     */
    int getCamToVpFaceNo();

    /**
     * JUPݒAUPxNgXChړJn܂B
     * @param tx JUPxNgXvf^[Qbg
     * @param ty JUPxNgYvf^[Qbg
     * @param tz JUPxNgZvf^[Qbg
     * @param t XChړv
     */
    void slideUpCamTo(coord tx, coord ty, coord tz, frame t);

    /**
     * JUPʔԍŐݒAUPxNgXChړJn܂B
     * @param prm_face_no JUPʔԍ
     * @param prm_t XChړv
     *
     */
    void slideUpCamTo(int prm_face_no, frame prm_t);

    /**
     * JwʒuɊ炩ړ܂B .
     * @param tx
     * @param ty
     * @param tz
     * @param t vt[
     */
    void slideMvTo(coord tx, coord ty, coord tz, frame t);

    void slideMvTo(coord tx, coord ty, coord tz, frame t,
                   float prm_x_p1, float prm_y_p1, float prm_z_p1);
    /**
     * Jw̃AN^[̈ʒuɊ炩ړ܂B .
     * @param pTarget
     * @param t vt[
     */
    void slideMvTo(GgafDxCore::GgafDxGeometricActor* pTarget, frame t);
    void slideMvTo(GgafDxCore::GgafDxGeometricActor* pTarget, frame t,
            float prm_x_p1, float prm_y_p1, float prm_z_p1);
    virtual ~Camera(); //fXgN^
};

}
#endif /*CAMERA_H_*/
