#ifndef GOD_H_
#define GOD_H_
#include "jp/ggaf/lib/DefaultGod.h"

#include "jp/ggaf/lib/util/VirtualButton.h"
#include "jp/gecchi/VioletVreath/GameGlobal.h"
#include "jp/gecchi/VioletVreath/manager/DepositoryManager.h"
#include "jp/gecchi/VioletVreath/manager/DepositoryConnection.h"
#include "jp/gecchi/VioletVreath/manager/SplineLineManager.h"
#include "jp/gecchi/VioletVreath/manager/SplineLineConnection.h"

#undef P_GOD
#define P_GOD ((VioletVreath::God*)VioletVreath::God::_pGod)

namespace VioletVreath {

/** Q[VirtualButton */
#define VB_PLAY VioletVreath::God::pVbtn_PLAY_
/** UI쎞VirtualButton */
#define VB_UI VioletVreath::God::pVbtn_UI_
/** VB_PLAY or VB_UI ̂ǂ炩ŁAANeBuȕVirtualButton */
#define VB VioletVreath::God::pVbtn_active_

/** Q[vC̃vCĐpǂݍ݃t@C */
#define FILE_INPUT_PLAY_REPLAY    "VB_PLAY.rep"
/** UĨvCĐpǂݍ݃t@C */
#define FILE_INPUT_UI_REPLAY      "VB_UI.rep"
/** Q[vC̃vCot@C */
#define FILE_OUTPUT_PLAY_REPLAY   "VB_PLAY_LAST.rep"
/** UĨvCot@C */
#define FILE_OUTPUT_UI_REPLAY     "VB_UI_LAST.rep"
/** Q[vC̃vCot@CifobOpoj */
#define FILE_REALTIME_OUTPUT_PLAY_REPLAY   "VB_PLAY_LAST_REALTIME.rep"
/** UĨvCot@CifobOpoj */
#define FILE_REALTIME_OUTPUT_UI_REPLAY     "VB_UI_LAST_REALTIME.rep"

/**
 * _ێ DepositoryManager ɐڑARlNV擾B
 * XFʕiDepositoryManager::processCreateResource(char* prm_idstr, void* prm_pConnector)  prm_idstr ɓn)
 */
#define connect_DepositoryManager(X) ((VioletVreath::DepositoryConnection*)(P_GOD->pDepoManager_->connect((X), this)))

/**
 * _ێ SplineLineManager ɐڑARlNV擾B
 * XFʕiSplineLineManager::processCreateResource(char* prm_idstr, void* prm_pConnector)  prm_idstr ɓn)
 */
#define connect_SplineLineManager(X)   ((VioletVreath::SplineLineConnection*)(P_GOD->pSpl3DManager_->connect((X), this)))

/**
 * _
 * @version 1.00
 * @since 2007/11/26
 * @author Masatoshi Tsuge
 */
class God : public GgafLib::DefaultGod {

public:
    DepositoryManager* pDepoManager_;
    SplineLineManager* pSpl3DManager_;

    static GgafLib::VirtualButton* pVbtn_PLAY_;
    static GgafLib::VirtualButton* pVbtn_UI_;
    static GgafLib::VirtualButton* pVbtn_active_;
    static GgafLib::VirtualButton* pVbtn_active_next_frame_;
    static bool g_should_reboot_;
public:
    /**
     * RXgN^ .
     * @param prm_hInstance
     * @param prm_pHWndPrimary PʖHWND
     * @param prm_pHWndSecondary QʖHWND
     */
    God();


    void initVB();

    /**
     * VBXV\񂷂B .
     * @param prm_pVB
     */
    void setVB(GgafLib::VirtualButton* prm_pVB) {
        if (pVbtn_active_ != prm_pVB) {
            //VB̃Zbg؂ւ
        }
        pVbtn_active_next_frame_ = prm_pVB;
    }

    /**
     * ̐̏uԂnOɁAVBXVB
     */
    virtual void presentUniversalMoment() override {
        //VB𔽉f
        pVbtn_active_ = pVbtn_active_next_frame_;
        //ʌĂяo
        GgafLib::DefaultGod::presentUniversalMoment();
    }

    /**
     * WorldV[쐬B
     */
    GgafCore::GgafUniverse* createUniverse() override;
    /**
     * AvP[VċN .
     */
    static void reboot();

    virtual void clean() override;

    virtual void oops() override;

    virtual ~God();
};

}

#endif /*GOD_H_*/
