#ifndef GGAFLIB_LINEAROCTREEFORACTOR_H_
#define GGAFLIB_LINEAROCTREEFORACTOR_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/util/GgafLinearOctree.h"

namespace GgafLib {

/**
 * GgafActorvfƂ蔻@\ǉ`ؔzNX .
 * AO[v  BO[v2O[vԂ̓蔻s
 * @version 1.00
 * @since 2009/11/23
 * @author Masatoshi Tsuge
 */
class LinearOctreeForActor : public GgafCore::GgafLinearOctree {

    uint32_t _num_space_minus_one;

public:
    /**
     * 蔻AN^[ێX^bN .
     * ̎lĂȂ댯ȃX^bN
     */
    class CollisionStack {
    public:
        /** [r]̋ԂɃX^bNAN^[̔z */
        GgafCore::GgafActor* _apActor[3000]; //PԂ 3000 LW܂Ȃ낤ƂՂŐ͂Ȍς
        /** [r]J[\|C^  */
        uint32_t _p;
    public:
        /**
         * RXgN^
         * @return
         */
        CollisionStack() {
            _p = 0;
        }
        /**
         * X^bNɐς .
         * @param prm_pActor ςރAN^[
         */
        inline void push(GgafCore::GgafActor* prm_pActor) {
            if (_p > 3000-1) {
                _TRACE_("LinearOctreeForActor::push("<<prm_pActor<<") X^bNg؂܂B܂Bӏɓ蔻肪߂łB");
                return;
            }
            _apActor[_p] = prm_pActor;
            _p++;
        }
        /**
         * X^bNo .
         * @return oꂽAN^[
         */
        inline GgafCore::GgafActor* pop() {
            if (_p == 0) {
                return nullptr;
            } else {
                _p--;
                return (_apActor[_p]);
            }
        }
        /**
         * ς񂾃X^bNȂɂB .
         */
        inline void clear() {
            _p = 0;
        }
        ~CollisionStack() {
            clear();
        }
        void dump() {
            TEXT5("CollisionStack.dump=");
            for (uint32_t i = 0; i < _p; i++) {
                TEXT5((_apActor[i]->getName())<<"->");
            }
            TEXT5("END");
        }
    };

    /** [r]SԂ̓蔻莞A݂̋ԂɏAN^[AO[ṽX^bN */
    CollisionStack _stackCurrentSpaceActor_GroupA;
    /** [r]SԂ̓蔻莞A݂̋ԂɏAN^[BO[ṽX^bN */
    CollisionStack _stackCurrentSpaceActor_GroupB;
    /** [r]Ԃ̓蔻莞AeԂɏSAN^[AO[ṽX^bN */
    CollisionStack _stackParentSpaceActor_GroupA;
    /** [r]Ԃ̓蔻莞AeԂɏSAN^[BO[ṽX^bN */
    CollisionStack _stackParentSpaceActor_GroupB;

    /** [r]񓖂蔻sAN^[A */
    actorkind _kind_groupA;
    /** [r]񓖂蔻sAN^[B */
    actorkind _kind_groupB;

public:
    /**
     * RXgN^
     * @param prm_level 쐬锪؋ԃx
     */
    explicit LinearOctreeForActor(int prm_level);

    /**
     * ؏́uAN^[AO[v  AN^[BO[vvs  .
     * Av͖{\bhĂԂł悢B<BR>
     *  executeAllHitChk  processJudgement() ŌĂԕKvB<BR>
     * @param prm_groupA AN^[AO[v
     * @param prm_groupB AN^[BO[v
     */
    void executeAllHitChk(actorkind prm_groupA, actorkind prm_groupB);

    /**
     * ̋Ԃ̓蔻s  .
     * executeAllHitChk gpB
     * @param prm_index `ؔz̔zvfԍ
     */
    void executeHitChk(uint32_t prm_index);

    /**
     * AN^[AO[ṽX^bNƁAAN^[BO[ṽX^bN̑̓蔻s  .
     * executeHitChk gpB
     * @param prm_pStackA AN^[AO[ṽX^bN
     * @param prm_pStackB AN^[BO[ṽX^bN
     */
    void executeHitChk_RoundRobin(CollisionStack* prm_pStackA, CollisionStack* prm_pStackB);


    virtual ~LinearOctreeForActor();
};


}
#endif /*GGAFLIB_LINEAROCTREEFORACTOR_H_*/

