#ifndef GRAPHBARACTOR_H_
#define GRAPHBARACTOR_H_
#include "jp/ggaf/lib/actor/DefaultBoardActor.h"
#include "jp/ggaf/lib/util/PxQuantity.h"

namespace GgafLib {

/**
 * ʃo[iP`j .
 * @version 1.00
 * @since 2013/09/17
 * @author Masatoshi Tsuge
 */
class GraphBarActor : public DefaultBoardActor {

protected:
    /** [r]RXgN^PxQuantity newꍇ true */
    bool _is_new_PxQuantity;
    /** [r]f`bvsNZ */
    const float _chip_width;
    /** [r] 1.0 / _chip_width ̒lBvZp */
    const float _rate_org_chip_width;

public:
    /** [r]ʃo[el */
    PxQuantity* _pPxQty;
    /** [r]ʃo[ől */
    int _min_val;
    /** [r]ʃo[ŏl */
    int _max_val;

public:
    /**
     *
     * @param prm_name
     * @param prm_pPxQty configς݂ PxQuantityIuWFNg̎Q
     */
    GraphBarActor(const char* prm_name, const char* prm_model, PxQuantity* prm_pPxQty);

    GraphBarActor(const char* prm_name, const char* prm_model);

    /**
     * ̃o[̒lێ PxQuantity u .
     * @param prm_pPxQty
     */
    void linkQty(PxQuantity* prm_pPxQty);

    /**
     * ̃o[̒lێ PxQuantity ̎QƕϐύX .
     * @param prm_pVariable
     */
    void linkVariable(int* prm_pVariable);

    /**
     * o[̒lɑ΂sNZ̖ڐtB
     * @param prm_min_val o[ŏlݒiȉ̒l̓ZbgłȂȂj
     * @param prm_max_val o[őlݒiȏ̒l̓ZbgłȂȂj
     * @param prm_px_from_min_to_max ŏl`ől̉ʏ̃sNZݒ
     */
    inline void graduate(int prm_min_val, int prm_max_val, pixcoord prm_px_from_min_to_max ) {
        _min_val = prm_min_val;
        _max_val = prm_max_val;
        _pPxQty->graduate(prm_max_val - prm_min_val, prm_px_from_min_to_max);
    }

    /**
     * o[̒lݒ .
     * linkĂꍇAN̒lύX̂Œ .
     * @param prm_val [^[l
     */
    inline void setQty(int prm_val) {
        if (_max_val < prm_val) {
            _pPxQty->set(_max_val);
        } else if (_min_val > prm_val) {
            _pPxQty->set(_min_val);
        } else {
            _pPxQty->set(prm_val);
        }
    }

    /**
     * o[̒l擾 .
     * @return o[̒l
     */
    inline int getQty() {
        return _pPxQty->get();
    }

    /**
     * o[̌ݒlɑΉsNZl擾
     * @return sNZl
     */
    inline pixcoord getBarPx() {
        return _pPxQty->getPx();
    }

    /**
     * o[̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val o[̉Zl
     */
    inline void incQty(int prm_val) {
        setQty(_pPxQty->get() + prm_val);
    }

    /**
     * o[̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val o[̌Zl
     */
    inline void decQty(int prm_val) {
        setQty(_pPxQty->get() - prm_val);
    }

    void processDraw() override;

    virtual ~GraphBarActor();
};

}
#endif /*GRAPHBARACTOR_H_*/

