#include "stdafx.h"
#include "EnemyStraea.h"

#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"
#include "jp/ggaf/core/actor/ex/GgafActorDepositoryStore.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/CommonScene.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


EnemyStraea::EnemyStraea(const char* prm_name) :
        DefaultMeshActor(prm_name, "Straea", STATUS(EnemyStraea)) {

    //[U[
    laser_way_ = 3;
    cnt_laserchip_ = 0;
    _X = 0;
    _Y = 0;
    _Z = 0;
    laser_length_ = 30;
    laser_interval_ = 300;
    angveloTurn_ = 5000;
    angClearance_ = 30000;//J
    papapLaserChipDepo_ = NEW LaserChipDepository**[laser_way_];
    for (int i = 0; i < laser_way_; i++) {
        papapLaserChipDepo_[i] = NEW LaserChipDepository*[laser_way_];
        for (int j = 0; j < laser_way_; j++) {
            papapLaserChipDepo_[i][j] = nullptr;
        }
    }

    pConn_RefractionEffectDepository_ = connect_DepositoryManager("EffRefraction001");
    pConn_LaserChipDepoStore_ = connect_DepositoryManager(
            "EnemyStraeaLaserChip004DepoStore"//,
         //"EnemyStraeaLaserChip003DepoStore",
         //"EnemyStraeaLaserChip001DepoStore",
         //"EnemyStraeaLaserChip002DepoStore",
         //pConn_RefractionEffectDepository_->peek()
        );

    papaPosLaser_ = NEW PosLaser*[laser_way_];
    angle* paAng_way = NEW angle[laser_way_];
    UTIL::getWayAngle2D(0, laser_way_, angClearance_, paAng_way);
    angle Rz,Ry;
    float vx, vy, vz;
    for (int i = 0; i < laser_way_; i++) {
        Rz = UTIL::simplifyAng(paAng_way[i]);
        papaPosLaser_[i] = NEW PosLaser[laser_way_];
        for (int j = 0; j < laser_way_; j++) {
            Ry = UTIL::simplifyAng(paAng_way[j]);
            UTIL::convRzRyToVector(Rz, Ry, vx, vy, vz);
            papaPosLaser_[i][j].X = vx * PX_C(100);
            papaPosLaser_[i][j].Y = vy * PX_C(100);
            papaPosLaser_[i][j].Z = vz * PX_C(100);
        }
    }
    GGAF_DELETEARR(paAng_way);

    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_MIDDLE_001");
    _pSeTx->set(SE_FIRE     , "WAVE_ENEMY_FIRE_LASER_001");

    useProgress(PROG_FIRE);
    pConn_ShotDepo2_ = connect_DepositoryManager("Shot004Yellow");
    pConn_ShotDepo3_ = connect_DepositoryManager("Shot004Blue");
}

void EnemyStraea::onCreateModel() {
    _pModel->_pTexBlinker->setBlinkableRange(0.97, 0.5, 12.0);
    _pModel->_pTexBlinker->setPower(1.0);
    _pModel->_pTexBlinker->beat(60*6, 60*2, 60*2, -1);
}

void EnemyStraea::initialize() {
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliSphere(0, PX_C(200));
    _pKurokoA->setRzRyMvAng(0, D180ANG);
    _pKurokoA->setMvVelo(PX_C(5));
}

void EnemyStraea::onActive() {
    _pStatus->reset();
    setHitAble(false);
    _X = GgafDxCore::GgafDxUniverse::_X_gone_right - 1000;
    _pProg->reset(PROG_ENTRY);
}

void EnemyStraea::processBehavior() {

    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));
    switch (_pProg->get()) {
        case PROG_ENTRY: {
            if (_pProg->isJustChanged()) {
                UTIL::activateEntryEffectOf(this);
                _pAFader->setAlpha(0);
                _pAFader->fadeLinerUntil(0.98, 20);
                _pKurokoA->setFaceAngVelo(AXIS_X, 4000);
            }
            if (!_pAFader->isFading()) {
                setHitAble(true);
                _pProg->changeNext();
            }
            _pAFader->behave();
            break;
        }
        case PROG_MOVE: {
            if (_pProg->isJustChanged()) {
                angle v = angveloTurn_ / 50;
                _pKurokoA->setFaceAngVelo(RND(-v, v), RND(-v, v), RND(-v, v));
                _pKurokoA->setMvVelo(2000);
                //_pKurokoA->setMvVelo(0);
            }
            if (getActiveFrame() % laser_interval_ == 0) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_TURN: {
            if (_pProg->isJustChanged()) {
                //^[Jn
                _pKurokoA->turnFaceAngTwd(P_MYSHIP,
                                          angveloTurn_, 0, TURN_ANTICLOSE_TO, false);
                cnt_laserchip_ = 0;
            }
            if (_pKurokoA->isTurningFaceAng()) {
                //^[
            } else {
                //@ɂɐU
                _pKurokoA->setFaceAngVelo(angveloTurn_*2, 0, 0);
                _pKurokoA->setMvVelo(0);
                _pProg->changeNext();
            }
            break;
        }

        case PROG_FIRE: {
            if (_pProg->isJustChanged()) {
                //[U[ZbgAؓ
                GgafActorDepositoryStore* pLaserChipDepoStore =
                        (GgafActorDepositoryStore*)(pConn_LaserChipDepoStore_->peek());
                bool can_fire = false;
                for (int i = 0; i < laser_way_; i++) {
                    for (int j = 0; j < laser_way_; j++) {
                        papapLaserChipDepo_[i][j] = (LaserChipDepository*)(pLaserChipDepoStore->dispatch());
                        if (papapLaserChipDepo_[i][j]) {
                            papapLaserChipDepo_[i][j]->config(laser_length_, 1);
                            can_fire = true;
                        }
                    }
                }
                if (can_fire) {
                    _pSeTx->play3D(SE_FIRE); //ˉ
                    effectFlush(2); //tbV
                }
            }
            if (cnt_laserchip_ < laser_length_) {
                cnt_laserchip_++;
                LaserChip* pLaserChip;
                PosLaser* p;
                D3DXMATRIX matWorldRot;
                UTIL::setWorldMatrix_RxRzRy(this, matWorldRot);
                angle Rz, Ry;
                int vX, vY, vZ;
                for (int i = 0; i < laser_way_; i++) {
                    for (int j = 0; j < laser_way_; j++) {
                        if (papapLaserChipDepo_[i][j]) {
                            pLaserChip = papapLaserChipDepo_[i][j]->dispatch();
                            if (pLaserChip) {
                                //[U[̌vZ
                                //[Jł̃Vbg̕xNg(Xorg_,Yorg_,Zorg_)A
                                //[hϊs̉]imatWorldRot)̐ mat_xxA
                                //ŏIIȕxNg(vX, vY, vZ) Ƃ
                                //
                                //                       | mat_11 mat_12 mat_13 |
                                // | Xorg_ Yorg_ Zorg_ | | mat_21 mat_22 mat_23 | = | vX vY vZ |
                                //                       | mat_31 mat_32 mat_33 |
                                //
                                // vX = Xorg_*mat_11 + Yorg_*mat_21 + Zorg_*mat_31
                                // vY = Xorg_*mat_12 + Yorg_*mat_22 + Zorg_*mat_32
                                // vZ = Xorg_*mat_13 + Yorg_*mat_23 + Zorg_*mat_33
                                p = &(papaPosLaser_[i][j]);
                                vX = p->X*matWorldRot._11 + p->Y*matWorldRot._21 + p->Z*matWorldRot._31;
                                vY = p->X*matWorldRot._12 + p->Y*matWorldRot._22 + p->Z*matWorldRot._32;
                                vZ = p->X*matWorldRot._13 + p->Y*matWorldRot._23 + p->Z*matWorldRot._33;
                                UTIL::convVectorToRzRy(vX, vY, vZ, Rz, Ry); //݂̍ŏIIȌARzRyŎ擾
                                pLaserChip->position(_X+vX, _Y+vY, _Z+vZ);
                                pLaserChip->_pKurokoA->setRzRyMvAng(Rz, Ry);
                                pLaserChip->_pKurokoA->_angFace[AXIS_Z] = Rz;
                                pLaserChip->_pKurokoA->_angFace[AXIS_Y] = Ry;
                            }
                        }
                    }
                }
            } else {
                _pProg->change(PROG_MOVE);
            }
            break;
        }
    }
    _pSeTx->behave();
    _pKurokoA->behave();
}

void EnemyStraea::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyStraea::onHit(GgafActor* prm_pOtherActor) {
    static uint32_t spritedoller[24] = {
                                     6144      ,       //  000000000001100000000000
                                     14336     ,       //  000000000011100000000000
                                     13312     ,       //  000000000011010000000000
                                     25088     ,       //  000000000110001000000000
                                     49408     ,       //  000000001100000100000000
                                     98432     ,       //  000000011000000010000000
                                     196704    ,       //  000000110000000001100000
                                     393528    ,       //  000001100000000100111000
                                     917407    ,       //  000011011111111110011111
                                     3145734   ,       //  001100000000000000000110
                                     12582912  ,       //  110000000000000000000000
                                     1098776   ,       //  000100001100010000011000
                                     2091004   ,       //  000111111110011111111100
                                     1623576   ,       //  000110001100011000011000
                                     1623576   ,       //  000110001100011000011000
                                     1623576   ,       //  000110001100011000011000
                                     1623576   ,       //  000110001100011000011000
                                     1623576   ,       //  000110001100011000011000
                                     1623576   ,       //  000110001100011000011000
                                     1623576   ,       //  000110001100011000011000
                                     2082552   ,       //  000111111100011011111000
                                     1623600   ,       //  000110001100011000110000
                                     1536      ,       //  000000000000011000000000
                                     1536              //  000000000000011000000000
    };


    static uint32_t red_dot[11] = {
            32  ,       //  00000100000
            112 ,       //  00001110000
            248 ,       //  00011111000
            428 ,       //  00110101100
            32  ,       //  00000100000
            0   ,       //  00000000000
            0   ,       //  00000000000
            0   ,       //  00000000000
            0   ,       //  00000000000
            0   ,       //  00000000000
            0           //  00000000000
    };
    static uint32_t yellow_dot[11] = {
            0   ,       //  00000000000
            0   ,       //  00000000000
            0   ,       //  00000000000
            594 ,       //  01001010010
            990 ,       //  01111011110
            508 ,       //  00111111100
            168 ,       //  00010101000
            32  ,       //  00000100000
            32  ,       //  00000100000
            32  ,       //  00000100000
            32          //  00000100000
        };
    static uint32_t blue_dot[11] = {
            0   ,       //  00000000000
            1025,       //  10000000001
            1025,       //  10000000001
            1025,       //  10000000001
            1025,       //  10000000001
            1539,       //  11000000011
            774 ,       //  01100000110
            396 ,       //  00110001100
            136 ,       //  00010001000
            0   ,       //  00000000000
            0           //  00000000000
        };


    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
        //łԂ
        UTIL::shotWay003(this,
                         getCommonDepository(Shot004) , red_dot,
                         pConn_ShotDepo2_->peek(), yellow_dot,
                         pConn_ShotDepo3_->peek(), blue_dot,
                         PX_C(20),
                         11, 11,
                         D_ANG(1), D_ANG(1),
                         5000, 100,
                         2, 1, 0.9);
    } else {
        //j
    }
}


void EnemyStraea::onInactive() {
    //[U[f|Wg͒xĂ߂
    for (int i = 0; i < laser_way_; i++) {
        for (int j = 0; j < laser_way_; j++) {
            if (papapLaserChipDepo_[i][j]) {
                papapLaserChipDepo_[i][j]->sayonara(60*10);
            }
        }
    }
    sayonara();
}


EnemyStraea::~EnemyStraea() {
    pConn_RefractionEffectDepository_->close();
    pConn_LaserChipDepoStore_->close();
    pConn_ShotDepo2_->close();
    pConn_ShotDepo3_->close();
    for (int i = 0; i < laser_way_; i++) {
        GGAF_DELETEARR(papaPosLaser_[i]);
        GGAF_DELETEARR(papapLaserChipDepo_[i]);
    }
    GGAF_DELETEARR(papaPosLaser_);
    GGAF_DELETEARR(papapLaserChipDepo_);
}
