#ifndef ENEMYESPERIA_H_
#define ENEMYESPERIA_H_
#include "jp/ggaf/lib/actor/DefaultMorphMeshActor.h"

namespace VioletVreath {

/**
 * G@GXyA .
 * [U[݂͂ȁEEE
 * @version 1.00
 * @since 2012/08/29
 * @author Masatoshi Tsuge
 */
class EnemyEsperia : public GgafLib::DefaultMorphMeshActor {

private:
    /** ˍς݃[U[`bv */
    int cnt_laserchip_;

public:
    enum {
        PROG_ENTRY,
        PROG_MOVE,
        PROG_HATCH_OPEN,
        PROG_FIRE,
        PROG_HATCH_CLOSE,
        PROG_NOTHING,
    };

    enum {
        SE_EXPLOSION,
        SE_DAMAGED,
        SE_HATCH_OPEN,
        SE_FIRE,
        SE_HATCH_CLOSE,
    };

    /** [r]GXyAP͂Ԃۂ̍ő僌[U[Way */
    static int max_laser_way_;
    /** [r]{GXyA̍̃[U[Way */
    int now_laser_way_;
    /** [r]˃[U[`bv̐i[U[j */
    int laser_length_;
    /** [r][U[ˎX̎@Ƃ̋ */
    coord dX_;
    /** [r][U[ˎZ̎@Ƃ̋ */
    coord dZ_;
    /** [r][U[ˈʒu̍WiGXyÃ[JWj */
    GgafDxCore::GgafDxGeoElem* paLocalPos_Laser_;
    /** [r][U[ˎAڕWʒu̍Wi@̑΍Wj */
    GgafDxCore::GgafDxGeoElem* paPos_Target_;
    /** [r][U[Zbg̃XgA[([U[`bṽf|Wg̃f|Wg) */
    GgafCore::GgafActorDepositoryStore* pLaserChipDepoStore_;
    /** [r]f|Wg}l[W[ւ̐ڑ */
    DepositoryConnection* pConn_LaserChipDepoStore_;
    /** [r][U[Zbg([U[`bṽf|Wg) */
    GgafLib::LaserChipDepository** papLaserChipDepo_;

public:
    EnemyEsperia(const char* prm_name);

    void onCreateModel() override;

    void initialize() override;

    void onActive() override;

    void processBehavior() override;

    void processJudgement() override;

    void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;

    void onInactive() override;

    /**
     * [U[U艺낷߂̏㏸iYj߂ .
     * <pre>
     *                         ^ Y
     *                         |
     *                         |cccc
     *                       ^|     ^
     *                     ^  |     |
     *                   ^    |     | DYiԂlj
     *                 ^      |     |
     *               ^        |     v
     *             ^         Gcccc
     *           ^=T     |
     *     ---@-------------+--------->
     *       ^:               |
     *     ^  :               |
     *   ^    :<------------->|
     *         :     DT()  |
     * </pre>
     * @param pThis
     * @param pMyShip
     * @param DT
     * @return ㏸YiDYj
     */
    static coord getTurnDY(GgafDxCore::GgafDxGeometricActor* pThis,
                           GgafDxCore::GgafDxGeometricActor* pMyShip,
                           coord DT);

    virtual ~EnemyEsperia();
};

}
#endif /*ENEMYESPERIA_H_*/

