{ nixpkgs ? import <nixpkgs> {} }:
let
  inherit (nixpkgs) pkgs;
  eggs = import ./eggs.nix {
    inherit pkgs;
    stdenv = pkgs.stdenv;
  };
in pkgs.stdenv.mkDerivation {
  name = "cammy-env";
  buildInputs = with pkgs; [
    # debugging native code
    gdb checksec
    # maintaining movelist/
    egg2nix
    # maintaining cammy-rpy/
    pythonPackages.pyflakes
    # developing cammy-weave
    pandoc texlive.combined.scheme-small
    # using cammy-repl
    rlwrap
    # working with sexps
    ocamlPackages.sexp
    # benchmarking
    busybox feedgnuplot
    # publishing
    keychain mktorrent pngcrush
    # experimenting with GLSL
    mesa-demos
    # experimenting with verified compilation
    # coq
    # comparing prototypes
    sloccount
    # experimenting with hive management
    ranger
  ];
}
