(import (chicken process-context))
(import (matchable))
(import (mini-kanren))

; Relate a Cammy expression to its input and output types.
; cammy° is functional; expr fixes s and t together.
(define (cammyo expr s t)
  (conde
    ; Categories
    ((== expr 'id) (== s t))
    ((fresh (f g y) (== expr (list 'comp f g))
            (cammyo f s y) (cammyo g y t)))
    ; Binary Products
    ((== expr 'ignore) (== t '1))
    ((== expr 'fst) (fresh (x) (== s (list 'pair t x))))
    ((== expr 'snd) (fresh (x) (== s (list 'pair x t))))
    ((fresh (f g p1 p2) (== expr (list 'pair f g))
            (== t (list 'pair p1 p2)) (cammyo f s p1) (cammyo g s p2)))
    ; Binary Sums
    ((== expr 'left) (fresh (x) (== t (list 'sum s x))))
    ((== expr 'right) (fresh (x) (== t (list 'sum x s))))
    ((fresh (f g s1 s2) (== expr (list 'case f g))
            (== s (list 'sum s1 s2)) (cammyo f s1 t) (cammyo g s2 t)))
    ; Cartesian Closed Categories
    ((fresh (f y z) (== expr (list 'curry f))
            (== t (list 'hom y z)) (cammyo f (list 'pair s y) z)))
    ((fresh (f x y) (== expr (list 'uncurry f))
            (== s (list 'pair x y)) (cammyo f x (list 'hom y t))))
    ; Boolean algebra
    ((== expr 't) (== s '1) (== t '2))
    ((== expr 'f) (== s '1) (== t '2))
    ((== expr 'not) (== s '2) (== t '2))
    ((== expr 'conj) (== s (list 'pair '2 '2)) (== t '2))
    ((== expr 'disj) (== s (list 'pair '2 '2)) (== t '2))
    ((== expr 'either) (== s '2) (== t (list 'sum '1 '1)))
    ; NNO
    ((== expr 'zero) (== s '1) (== t 'N))
    ((== expr 'succ) (== s 'N) (== t 'N))
    ((fresh (x f) (== expr (list 'pr x f))
            (== s 'N) (cammyo x '1 t) (cammyo f t t)))
    ; Free Monoids
    ((== expr 'nil) (== s '1) (fresh (l) (== t (list 'list l))))
    ((== expr 'cons) (fresh (l) (== s (list 'pair l t)) (== t (list 'list l))))
    ((fresh (x f l) (== expr (list 'fold x f))
            (== s (list 'list l)) (cammyo x '1 t) (cammyo f (list 'pair l t) t)))
    ; Floating Point
    ((== expr 'f-zero) (== s '1) (== t 'F))
    ((== expr 'f-one) (== s '1) (== t 'F))
    ((== expr 'f-pi) (== s '1) (== t 'F))
    ((== expr 'f-sign) (== s 'F) (== t '2))
    ((== expr 'f-negate) (== s 'F) (== t 'F))
    ((== expr 'f-recip) (== s 'F) (== t 'F))
    ((== expr 'f-sin) (== s 'F) (== t 'F))
    ((== expr 'f-cos) (== s 'F) (== t 'F))
    ((== expr 'f-lt) (== s (list 'pair 'F 'F)) (== t '2))
    ((== expr 'f-add) (== s (list 'pair 'F 'F)) (== t 'F))
    ((== expr 'f-mul) (== s (list 'pair 'F 'F)) (== t 'F))
    ((== expr 'f-sqrt) (== s 'F) (== t (list 'sum 'F '1)))
    ((== expr 'f-floor) (== s 'F) (== t (list 'sum 'F '1)))
    ((== expr 'f-atan2) (== s (list 'pair 'F 'F)) (== t 'F))))

(define (type-check expr)
  (car (run 1 (q) (fresh (s t) (== q (list s t)) (cammyo expr s t)))))

(define (last xs)
  (if (null? (cdr xs)) (car xs) (last (cdr xs))))

(define (djinn x s t)
  (last (run x (q) (cammyo q s t))))

(match (map (lambda (s) (read (open-input-string s)))
            (command-line-arguments))
       [(in out (? number? count)) (begin (display (djinn count in out))
                                          (newline))])
