{ nixpkgs ? import <nixpkgs> {} }:
let
  inherit (nixpkgs) pkgs;
  jelly = (import jelly/Cargo.nix { pkgs = nixpkgs; }).rootCrate.build;
  movelist = import ./movelist { inherit nixpkgs; };
  cammy-draw = import ./cammy-rpy/draw.nix { inherit nixpkgs jelly; };
  cammy-frame = import ./cammy-rpy/frame.nix { inherit nixpkgs jelly; };
  cammy-repl = import ./cammy-rpy/repl.nix { inherit nixpkgs jelly; };
  cammy-weave = import ./cammy-rpy/weave.nix { inherit nixpkgs jelly; };
in pkgs.stdenv.mkDerivation {
  name = "cammy";
  version = "0.2";

  src = ./.;

  buildInputs = [ pkgs.makeWrapper ];

  installPhase = ''
    mkdir -p $out/bin/

    # djinn
    makeWrapper ${movelist}/bin/movelist $out/bin/cammy-djinn

    # jelly
    makeWrapper ${jelly}/bin/jelly $out/bin/cammy-jelly

    # RPython tools
    makeWrapper ${cammy-draw}/bin/cammy-draw $out/bin/cammy-draw
    makeWrapper ${cammy-frame}/bin/cammy-frame $out/bin/cammy-frame
    makeWrapper ${cammy-repl}/bin/cammy-repl $out/bin/cammy-repl
    makeWrapper ${cammy-weave}/bin/cammy-weave $out/bin/cammy-weave
  '';
}
