from rpython.rlib.rfile import create_stdio

from cammylib.hive import Hive, MissingAtom
from cammylib.parser import parse


def main(argv):
    hivepath = argv[-1]
    hive = Hive(hivepath)
    stdin, stdout, stderr = create_stdio()
    try:
        sexp, trail = parse(stdin.read())
        stdout.write(sexp.canonicalize(hive).asStr())
        stdout.write("\n")
        return 0
    except MissingAtom as ma:
        stderr.write("Missing atom in hive: ")
        stderr.write(ma.atom)
        stderr.write("\n")
        return 1

def target(driver, *args):
    driver.exe_name = "cammy-frame"
    return main, None
