/*
 * Copyright 2004-2012 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.framework.mock.portlet;

import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;

/**
 * Portletのモック用の<code>ServletOutputStream</code>の抽象クラスです。
 * 
 * @author shot
 */
public abstract class MockPortletOutputStream extends ServletOutputStream {

    /**
     * {@link PrintWriter}を返します。
     * 
     * @return {@link PrintWriter}
     */
    public abstract PrintWriter getPrintWriter();

    /**
     * {@link PrintWriter}を設定します。
     * 
     * @param writer
     */
    public abstract void setPrintWriter(PrintWriter writer);

}
