/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeRangeList {
    public static String MERGE_INFO_NONINHERITABLE_STRING = "*";
    private SVNMergeRange[] myRanges;

    public SVNMergeRangeList(long start, long end, boolean inheritable) {
        this(new SVNMergeRange(start, end, inheritable));
    }

    public SVNMergeRangeList(SVNMergeRange range) {
        this(new SVNMergeRange[]{range});
    }

    public SVNMergeRangeList(SVNMergeRange[] ranges) {
        this.myRanges = ranges == null ? new SVNMergeRange[]{} : ranges;
    }

    public SVNMergeRange[] getRanges() {
        return this.myRanges;
    }

    public List getRangesAsList() {
        LinkedList<SVNMergeRange> list = new LinkedList<SVNMergeRange>();
        for (int i = 0; i < this.myRanges.length; ++i) {
            SVNMergeRange range = this.myRanges[i];
            list.add(range);
        }
        return list;
    }

    public void pushRange(long start, long end, boolean inheritable) {
        SVNMergeRange[] ranges = new SVNMergeRange[this.myRanges.length + 1];
        ranges[ranges.length - 1] = new SVNMergeRange(start, end, inheritable);
        System.arraycopy(this.myRanges, 0, ranges, 0, this.myRanges.length);
        this.myRanges = ranges;
    }

    public int getSize() {
        return this.myRanges.length;
    }

    public boolean isEmpty() {
        return this.myRanges.length == 0;
    }

    public SVNMergeRangeList dup() {
        SVNMergeRange[] ranges = new SVNMergeRange[this.myRanges.length];
        for (int i = 0; i < this.myRanges.length; ++i) {
            SVNMergeRange range = this.myRanges[i];
            ranges[i] = range.dup();
        }
        return new SVNMergeRangeList(ranges);
    }

    public SVNMergeRangeList merge(SVNMergeRangeList rangeList) throws SVNException {
        SVNMergeRange range;
        int i = 0;
        int j = 0;
        SVNMergeRange lastRange = null;
        LinkedList resultRanges = new LinkedList();
        while (i < this.myRanges.length && j < rangeList.myRanges.length) {
            SVNMergeRange range1 = this.myRanges[i];
            SVNMergeRange range2 = rangeList.myRanges[j];
            int res = range1.compareTo(range2);
            if (res == 0) {
                if (range1.isInheritable() || range2.isInheritable()) {
                    range1.setInheritable(true);
                }
                lastRange = this.combineWithLastRange(resultRanges, lastRange, range1, true, false);
                ++i;
                ++j;
                continue;
            }
            if (res < 0) {
                lastRange = this.combineWithLastRange(resultRanges, lastRange, range1, true, false);
                ++i;
                continue;
            }
            lastRange = this.combineWithLastRange(resultRanges, lastRange, range2, true, false);
            ++j;
        }
        if (i < this.myRanges.length && j < rangeList.myRanges.length) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "ASSERTION FAILURE in SVNMergeRangeList.merge(): expected to reach the end of at least one range list");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        while (i < this.myRanges.length) {
            range = this.myRanges[i];
            lastRange = this.combineWithLastRange(resultRanges, lastRange, range, true, false);
            ++i;
        }
        while (j < rangeList.myRanges.length) {
            range = rangeList.myRanges[j];
            lastRange = this.combineWithLastRange(resultRanges, lastRange, range, true, false);
            ++j;
        }
        return SVNMergeRangeList.fromCollection(resultRanges);
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.myRanges.length; ++i) {
            SVNMergeRange range = this.myRanges[i];
            output = output + range.toString();
            if (i >= this.myRanges.length - 1) continue;
            output = output + ',';
        }
        return output;
    }

    public SVNMergeRangeList diff(SVNMergeRangeList eraserRangeList, boolean considerInheritance) {
        return this.removeOrIntersect(eraserRangeList, true, considerInheritance);
    }

    public SVNMergeRangeList intersect(SVNMergeRangeList rangeList, boolean considerInheritance) {
        return this.removeOrIntersect(rangeList, false, considerInheritance);
    }

    public boolean includes(long revision) {
        for (int i = 0; i < this.myRanges.length; ++i) {
            SVNMergeRange range = this.myRanges[i];
            if (revision <= range.getStartRevision() || revision > range.getEndRevision()) continue;
            return true;
        }
        return false;
    }

    public SVNMergeRangeList reverse() {
        if (this.myRanges.length != 0) {
            for (int i = 0; i < this.myRanges.length / 2; ++i) {
                int swapInex = this.myRanges.length - i - 1;
                SVNMergeRange range = this.myRanges[i];
                this.myRanges[i] = this.myRanges[swapInex].swapEndPoints();
                this.myRanges[swapInex] = range.swapEndPoints();
            }
            if (this.myRanges.length % 2 == 1) {
                this.myRanges[this.myRanges.length / 2].swapEndPoints();
            }
        }
        return this;
    }

    public SVNMergeRangeList getInheritableRangeList(long startRev, long endRev) {
        LinkedList<SVNMergeRange> inheritableRanges = new LinkedList<SVNMergeRange>();
        if (this.myRanges.length > 0) {
            if (!SVNRevision.isValidRevisionNumber(startRev) || !SVNRevision.isValidRevisionNumber(endRev) || endRev < startRev) {
                for (int i = 0; i < this.myRanges.length; ++i) {
                    SVNMergeRange range = this.myRanges[i];
                    if (!range.isInheritable()) continue;
                    SVNMergeRange inheritableRange = new SVNMergeRange(range.getStartRevision(), range.getEndRevision(), true);
                    inheritableRanges.add(inheritableRange);
                }
            } else {
                SVNMergeRange range = new SVNMergeRange(startRev, endRev, false);
                SVNMergeRangeList boundRangeList = new SVNMergeRangeList(range);
                return this.diff(boundRangeList, true);
            }
        }
        SVNMergeRange[] ranges = inheritableRanges.toArray(new SVNMergeRange[inheritableRanges.size()]);
        return new SVNMergeRangeList(ranges);
    }

    public SVNMergeRangeList compactMergeRanges() {
        LinkedList<SVNMergeRange> additiveSources = new LinkedList<SVNMergeRange>();
        LinkedList<SVNMergeRange> subtractiveSources = new LinkedList<SVNMergeRange>();
        for (int i = 0; i < this.myRanges.length; ++i) {
            SVNMergeRange range = this.myRanges[i].dup();
            if (range.getStartRevision() > range.getEndRevision()) {
                subtractiveSources.add(range);
                continue;
            }
            additiveSources.add(range);
        }
        RangeComparator1 comparator = new RangeComparator1();
        Collections.sort(additiveSources, comparator);
        this.removeRedundantRanges(additiveSources);
        Collections.sort(subtractiveSources, comparator);
        this.removeRedundantRanges(subtractiveSources);
        Iterator subtractiveSrcsIter = subtractiveSources.iterator();
        while (subtractiveSrcsIter.hasNext()) {
            SVNMergeRange range = (SVNMergeRange)subtractiveSrcsIter.next();
            range = range.dup();
            additiveSources.add(range);
        }
        Collections.sort(additiveSources, comparator);
        List compactedSources = this.compactAddSubRanges(additiveSources);
        Collections.sort(compactedSources, new RangeComparator2());
        return SVNMergeRangeList.fromCollection(compactedSources);
    }

    public static SVNMergeRangeList fromCollection(Collection mergeRanges) {
        return new SVNMergeRangeList(mergeRanges.toArray(new SVNMergeRange[mergeRanges.size()]));
    }

    private void removeRedundantRanges(List ranges) {
        SVNMergeRange range1 = null;
        SVNMergeRange range2 = null;
        for (int i = 0; i < ranges.size(); ++i) {
            if (range1 == null) {
                range1 = (SVNMergeRange)ranges.get(i);
                continue;
            }
            range2 = (SVNMergeRange)ranges.get(i);
            SVNMergeRange[] twoRanges = new SVNMergeRange[]{range1, range2};
            boolean isCompacted = this.compactRange(twoRanges);
            range1 = twoRanges[0];
            range2 = twoRanges[1];
            if (!isCompacted || range2 != null) continue;
            ranges.remove(i);
            --i;
        }
    }

    private List compactAddSubRanges(List sources) {
        LinkedList mergeRanges = new LinkedList(sources);
        SVNMergeRange range1 = null;
        SVNMergeRange range2 = null;
        for (int i = 0; i < mergeRanges.size(); ++i) {
            if (range1 == null) {
                range1 = (SVNMergeRange)sources.get(i);
                continue;
            }
            range2 = (SVNMergeRange)sources.get(i);
            SVNMergeRange[] twoRanges = new SVNMergeRange[]{range1, range2};
            boolean isCompacted = this.compactRange(twoRanges);
            range1 = twoRanges[0];
            range2 = twoRanges[1];
            if (!isCompacted) continue;
            if (range1 == null && range2 == null) {
                mergeRanges.remove(i - 1);
                mergeRanges.remove(i - 1);
                if (i <= 1) continue;
                range1 = (SVNMergeRange)mergeRanges.get(i - 2);
                continue;
            }
            if (range2 == null) {
                mergeRanges.remove(i);
                --i;
                continue;
            }
            range1 = range2;
        }
        return mergeRanges;
    }

    private boolean compactRange(SVNMergeRange[] ranges) {
        boolean range2IsReversed;
        SVNMergeRange range1 = ranges[0];
        SVNMergeRange range2 = ranges[1];
        if (range1 == null || range2 == null || !SVNRevision.isValidRevisionNumber(range1.getStartRevision()) || !SVNRevision.isValidRevisionNumber(range2.getStartRevision())) {
            return false;
        }
        boolean range1IsReversed = range1.getStartRevision() > range1.getEndRevision();
        boolean bl = range2IsReversed = range2.getStartRevision() > range2.getEndRevision();
        if (range1IsReversed) {
            range1 = range1.swapEndPoints();
        }
        if (range2IsReversed) {
            range2 = range2.swapEndPoints();
        }
        boolean isCompacted = false;
        if (range1.getStartRevision() <= range2.getEndRevision() && range2.getStartRevision() <= range1.getEndRevision()) {
            if (range1IsReversed == range2IsReversed) {
                range1.setStartRevision(Math.min(range1.getStartRevision(), range2.getStartRevision()));
                range1.setEndRevision(Math.min(range1.getEndRevision(), range2.getEndRevision()));
                range2 = null;
                ranges[1] = null;
            } else if (range1.getStartRevision() == range2.getStartRevision()) {
                if (range1.getEndRevision() == range2.getEndRevision()) {
                    range1 = null;
                    range2 = null;
                    ranges[0] = null;
                    ranges[1] = null;
                } else {
                    range1.setStartRevision(range1.getEndRevision());
                    range1.setEndRevision(range2.getEndRevision());
                    range2 = null;
                    ranges[1] = null;
                    range1IsReversed = range2IsReversed;
                }
            } else if (range1.getEndRevision() > range2.getEndRevision()) {
                if (range1.getStartRevision() < range2.getStartRevision()) {
                    long tmpRev = range1.getEndRevision();
                    range1.setEndRevision(range2.getStartRevision());
                    range2.setStartRevision(range2.getEndRevision());
                    range2.setEndRevision(tmpRev);
                    range2IsReversed = range1IsReversed;
                } else {
                    long tmpRev = range1.getStartRevision();
                    range1.setStartRevision(range2.getEndRevision());
                    range2.setEndRevision(tmpRev);
                }
            } else if (range1.getEndRevision() < range2.getEndRevision()) {
                long tmpRev = range1.getEndRevision();
                range1.setEndRevision(range2.getStartRevision());
                range2.setStartRevision(tmpRev);
            } else {
                range1.setEndRevision(range2.getStartRevision());
                range2 = null;
                ranges[1] = null;
            }
            isCompacted = true;
        }
        if (range1 != null && range1IsReversed) {
            range1 = range1.swapEndPoints();
        }
        if (range2 != null && range2IsReversed) {
            range2 = range2.swapEndPoints();
        }
        return isCompacted;
    }

    private SVNMergeRangeList removeOrIntersect(SVNMergeRangeList rangeList, boolean remove, boolean considerInheritance) {
        LinkedList<SVNMergeRange> ranges = new LinkedList<SVNMergeRange>();
        SVNMergeRange lastRange = null;
        SVNMergeRange range1 = null;
        int i = 0;
        int j = 0;
        int lastInd = -1;
        SVNMergeRange whiteBoardElement = new SVNMergeRange(-1L, -1L, false);
        while (i < this.myRanges.length && j < rangeList.myRanges.length) {
            SVNMergeRange tmpRange;
            SVNMergeRange range2 = rangeList.myRanges[j];
            if (i != lastInd) {
                tmpRange = this.myRanges[i];
                whiteBoardElement = range1 = tmpRange.dup();
                lastInd = i;
            }
            if (range2.contains(range1, considerInheritance)) {
                if (!remove) {
                    lastRange = this.combineWithLastRange(ranges, lastRange, range1, true, considerInheritance);
                }
                ++i;
                if (range1.getStartRevision() != range2.getStartRevision() || range1.getEndRevision() != range2.getEndRevision()) continue;
                ++j;
                continue;
            }
            if (range2.intersects(range1, considerInheritance)) {
                if (range1.getStartRevision() < range2.getStartRevision()) {
                    tmpRange = null;
                    tmpRange = remove ? new SVNMergeRange(range1.getStartRevision(), range2.getStartRevision(), range1.isInheritable()) : new SVNMergeRange(range2.getStartRevision(), Math.min(range1.getEndRevision(), range2.getEndRevision()), range1.isInheritable());
                    lastRange = this.combineWithLastRange(ranges, lastRange, tmpRange, true, considerInheritance);
                }
                if (range1.getEndRevision() > range2.getEndRevision()) {
                    if (!remove) {
                        tmpRange = new SVNMergeRange(Math.max(range1.getStartRevision(), range2.getStartRevision()), range2.getEndRevision(), range1.isInheritable());
                        lastRange = this.combineWithLastRange(ranges, lastRange, tmpRange, true, considerInheritance);
                    }
                    whiteBoardElement.setStartRevision(range2.getEndRevision());
                    whiteBoardElement.setEndRevision(range1.getEndRevision());
                    continue;
                }
                ++i;
                continue;
            }
            if (range2.compareTo(range1) < 0) {
                ++j;
                continue;
            }
            if (lastRange == null || !lastRange.canCombine(range1, considerInheritance)) {
                if (remove) {
                    lastRange = range1.dup();
                    ranges.add(lastRange);
                }
            } else if (lastRange != null && lastRange.canCombine(range1, considerInheritance)) {
                lastRange = lastRange.combine(range1, considerInheritance);
            }
            ++i;
        }
        if (remove) {
            if (i == lastInd && i < this.myRanges.length) {
                lastRange = this.combineWithLastRange(ranges, lastRange, whiteBoardElement, true, considerInheritance);
                ++i;
            }
            while (i < this.myRanges.length) {
                SVNMergeRange range = this.myRanges[i];
                lastRange = this.combineWithLastRange(ranges, lastRange, range, true, considerInheritance);
                ++i;
            }
        }
        return SVNMergeRangeList.fromCollection(ranges);
    }

    private SVNMergeRange combineWithLastRange(Collection rangeList, SVNMergeRange lastRange, SVNMergeRange mRange, boolean dupMRange, boolean considerInheritance) {
        SVNMergeRange pushedMRange1 = null;
        SVNMergeRange pushedMRange2 = null;
        boolean rangesIntersect = false;
        boolean rangesHaveSameInheritance = false;
        if (lastRange != null) {
            if (lastRange.getStartRevision() <= mRange.getEndRevision() && mRange.getStartRevision() <= lastRange.getEndRevision()) {
                rangesIntersect = true;
            }
            if (lastRange.isInheritable() == mRange.isInheritable()) {
                rangesHaveSameInheritance = true;
            }
        }
        if (lastRange == null || !rangesIntersect || !rangesHaveSameInheritance && considerInheritance) {
            pushedMRange1 = dupMRange ? mRange.dup() : mRange;
        } else {
            long tmpRevision = -1L;
            if (rangesHaveSameInheritance) {
                lastRange.setStartRevision(Math.min(lastRange.getStartRevision(), mRange.getStartRevision()));
                lastRange.setEndRevision(Math.max(lastRange.getEndRevision(), mRange.getEndRevision()));
                lastRange.setInheritable(lastRange.isInheritable() || mRange.isInheritable());
            } else if (lastRange.getStartRevision() == mRange.getStartRevision()) {
                if (lastRange.getEndRevision() == mRange.getEndRevision()) {
                    lastRange.setInheritable(true);
                } else if (lastRange.getEndRevision() > mRange.getEndRevision()) {
                    if (!lastRange.isInheritable()) {
                        tmpRevision = lastRange.getEndRevision();
                        lastRange.setEndRevision(mRange.getEndRevision());
                        lastRange.setInheritable(true);
                        pushedMRange1 = dupMRange ? mRange.dup() : mRange;
                        pushedMRange1.setEndRevision(tmpRevision);
                        lastRange = pushedMRange1;
                    }
                } else if (mRange.isInheritable()) {
                    lastRange.setInheritable(true);
                    lastRange.setEndRevision(mRange.getEndRevision());
                } else {
                    pushedMRange1 = dupMRange ? mRange.dup() : mRange;
                    pushedMRange1.setStartRevision(lastRange.getEndRevision());
                }
            } else if (lastRange.getEndRevision() == mRange.getEndRevision()) {
                if (lastRange.getStartRevision() < mRange.getStartRevision()) {
                    if (!lastRange.isInheritable()) {
                        lastRange.setEndRevision(mRange.getStartRevision());
                        pushedMRange1 = dupMRange ? mRange.dup() : mRange;
                        lastRange = pushedMRange1;
                    }
                } else {
                    lastRange.setStartRevision(mRange.getStartRevision());
                    lastRange.setEndRevision(mRange.getEndRevision());
                    lastRange.setInheritable(mRange.isInheritable());
                    pushedMRange1 = dupMRange ? mRange.dup() : mRange;
                    pushedMRange1.setStartRevision(lastRange.getEndRevision());
                    pushedMRange1.setInheritable(true);
                }
            } else if (lastRange.getStartRevision() < mRange.getStartRevision()) {
                if (lastRange.getEndRevision() <= mRange.getEndRevision() || !lastRange.isInheritable()) {
                    tmpRevision = lastRange.getEndRevision();
                    if (!lastRange.isInheritable()) {
                        lastRange.setEndRevision(mRange.getStartRevision());
                    } else {
                        mRange.setStartRevision(lastRange.getEndRevision());
                    }
                    pushedMRange1 = dupMRange ? mRange.dup() : mRange;
                    if (tmpRevision > mRange.getEndRevision()) {
                        pushedMRange2 = new SVNMergeRange(mRange.getEndRevision(), tmpRevision, lastRange.isInheritable());
                    }
                    mRange.setInheritable(true);
                }
            } else if (lastRange.getEndRevision() < mRange.getEndRevision()) {
                if (pushedMRange2 == null) {
                    pushedMRange2 = new SVNMergeRange(lastRange.getEndRevision(), mRange.getEndRevision(), mRange.isInheritable());
                } else {
                    pushedMRange2.setStartRevision(lastRange.getEndRevision());
                    pushedMRange2.setEndRevision(mRange.getEndRevision());
                    pushedMRange2.setInheritable(mRange.isInheritable());
                }
                tmpRevision = lastRange.getStartRevision();
                lastRange.setStartRevision(mRange.getStartRevision());
                lastRange.setEndRevision(tmpRevision);
                lastRange.setInheritable(mRange.isInheritable());
                mRange.setStartRevision(tmpRevision);
                mRange.setEndRevision(pushedMRange2.getStartRevision());
                mRange.setInheritable(true);
            } else {
                if (pushedMRange2 == null) {
                    pushedMRange2 = new SVNMergeRange(mRange.getEndRevision(), lastRange.getEndRevision(), lastRange.isInheritable());
                } else {
                    pushedMRange2.setStartRevision(mRange.getEndRevision());
                    pushedMRange2.setEndRevision(lastRange.getEndRevision());
                    pushedMRange2.setInheritable(lastRange.isInheritable());
                }
                tmpRevision = lastRange.getStartRevision();
                lastRange.setStartRevision(mRange.getStartRevision());
                lastRange.setEndRevision(tmpRevision);
                lastRange.setInheritable(mRange.isInheritable());
                mRange.setStartRevision(tmpRevision);
                mRange.setEndRevision(pushedMRange2.getStartRevision());
                mRange.setInheritable(true);
            }
        }
        if (pushedMRange1 != null) {
            rangeList.add(pushedMRange1);
            lastRange = pushedMRange1;
        }
        if (pushedMRange2 != null) {
            rangeList.add(pushedMRange2);
            lastRange = pushedMRange2;
        }
        return lastRange;
    }

    private static int compareMergeRanges(Object o1, Object o2) {
        SVNMergeRange r1 = (SVNMergeRange)o1;
        SVNMergeRange r2 = (SVNMergeRange)o2;
        SVNMergeRange range1 = new SVNMergeRange(Math.min(r1.getStartRevision(), r1.getEndRevision()), Math.max(r1.getStartRevision(), r1.getEndRevision()), true);
        SVNMergeRange range2 = new SVNMergeRange(Math.min(r2.getStartRevision(), r2.getEndRevision()), Math.max(r2.getStartRevision(), r2.getEndRevision()), true);
        return range1.compareTo(range2);
    }

    private static class RangeComparator2
    implements Comparator {
        private RangeComparator2() {
        }

        public int compare(Object o1, Object o2) {
            boolean r2IsReversed;
            SVNMergeRange r1 = (SVNMergeRange)o1;
            SVNMergeRange r2 = (SVNMergeRange)o2;
            boolean r1IsReversed = r1.getStartRevision() > r1.getEndRevision();
            boolean bl = r2IsReversed = r2.getStartRevision() > r2.getEndRevision();
            if (r1IsReversed && r2IsReversed) {
                return -1 * SVNMergeRangeList.compareMergeRanges(o1, o2);
            }
            if (r1IsReversed) {
                return 1;
            }
            if (r2IsReversed) {
                return -1;
            }
            return SVNMergeRangeList.compareMergeRanges(o1, o2);
        }
    }

    private static class RangeComparator1
    implements Comparator {
        private RangeComparator1() {
        }

        public int compare(Object o1, Object o2) {
            return SVNMergeRangeList.compareMergeRanges(o1, o2);
        }
    }
}

