/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;

public class ValueDate
extends Value {
    public static final int PRECISION = 8;
    public static final int DISPLAY_SIZE = 10;
    private final Date value;

    private ValueDate(Date value) {
        this.value = value;
    }

    public static Date parseDate(String s) throws SQLException {
        return (Date)DateTimeUtils.parseDateTime(s, 10, 90009);
    }

    public Date getDate() {
        return (Date)this.value.clone();
    }

    public Date getDateNoCopy() {
        return this.value;
    }

    public String getSQL() {
        return "DATE '" + this.getString() + "'";
    }

    public int getType() {
        return 10;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueDate v = (ValueDate)o;
        int c = this.value.compareTo(v.value);
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public String getString() {
        int year;
        String s = this.value.toString();
        long time = this.value.getTime();
        if (time < ValueTimestamp.YEAR_ONE && (year = DateTimeUtils.getDatePart(this.value, 1)) < 1) {
            s = year + s.substring(s.indexOf(45));
        }
        return s;
    }

    public long getPrecision() {
        return 8L;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.getDate();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDate(parameterIndex, this.value);
    }

    public static ValueDate get(Date date) {
        date = DateTimeUtils.cloneAndNormalizeDate(date);
        return ValueDate.getNoCopy(date);
    }

    public static ValueDate getNoCopy(Date date) {
        return (ValueDate)Value.cache(new ValueDate(date));
    }

    public int getDisplaySize() {
        return 10;
    }

    public boolean equals(Object other) {
        return other instanceof ValueDate && this.value.equals(((ValueDate)other).value);
    }
}

