using System;
using System.Windows.Forms;
using System.Xml;
using nft.framework;
using nft.contributions.ui;
using WeifenLuo.WinFormsUI.Docking;
using nft.ui.mainframe_old;
using nft.framework.plugin;
using nft.ui.docking;

namespace nft.ui.command {
    /// <summary>
    /// 
    /// </summary>
    public class SubformCommand : ITriggerCommandProcedure, IDockContentFactory {

        readonly CtbSubform innerCtb;

        public SubformCommand(ParamsReader e) {
            innerCtb = new CtbSubform(null, e);
        }

        public DockContent CreateDockContent(string subkey) {
            return innerCtb.GetContent(subkey, true).Parent as DockContent;
        }

        public void Execute() {
            innerCtb.Show("");
        }

        public virtual bool Enable {
            get { return true; }
        }

        public event EventHandler EnableChanged;
    }
}
