using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;
using nft.ui.command;

namespace nft.ui.mainframe
{
	/// <summary>
    /// IMenuBarController ̊Tv̐łB
	/// </summary>
	public interface IMenuBarController
	{                

		/// <summary>
        /// Create MenuItem.
        /// </summary>
		/// <param name="cui">the source command ui</param>
		/// <param name="pathHint">menu path hint to locate menu item.</param>
        void AddMenuItem(CommandUI cui, CommandPathHint pathHint);

		/// <summary>
		/// Set ICommandEntity as a click event handler of specified menu item.
		/// </summary>
        /// <param name="procedure"></param>
		/// <param name="path"></param>
		/// <returns></returns>
		void BindCommand( ICommandProcedure procedure, CommandUI ui, string path );

    }
}
