﻿using nft.framework;
using nft.ui.command;
using nft.ui.mainframe_old;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace nft.ui.mainframe {
    public interface IMainFrame {

        event EventHandler<EventArgs> ActiveViewChanged;
        event EventHandler<EventArgs> ActiveSubformChanged;

        /// <summary>
        /// Give Window Handle.
        /// </summary>
        IntPtr Handle { get; }
        /// <summary>
        /// Get Size of Client Area
        /// </summary>
        Size ClientSize { get; }

        /// <summary>
        /// the MenuBarController instance of the mainframe
        /// </summary>
        IMenuBarController MenuBarController { get; }

        /// <summary>
        /// the ToolBarController instance of the mainframe
        /// </summary>
        IToolBarController ToolBarController { get; }

        /// <summary>
        /// Create UI dependent ICommandProcedure if possible, return null otherwise.
        /// </summary>
        /// <param name="commandType">String identifer of command type</param>
        /// <param name="targetType">class To be instanciated</param>
        /// <param name="reader">ParamsReader</param>
        /// <returns></returns>
        ICommandProcedure Createprocedure(string commandType, Type targetType, ParamsReader reader);

        /// <summary>
        /// Show the frame
        /// </summary>
        void Show();

        /// <summary>
        /// Register the form as MDI child frame of MainFrame.
        /// </summary>
        /// <param name="frame"></param>
        void AddView(String caption, IView content);

        IView ActiveView { get; set; }

    }
}
