﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.ui.form
{
    public interface IxControl
    {
        string Name { get; }
        bool Enabled { get; set; }
        bool Visible { get; set; }
    }

    public delegate bool Validator<T>(T testVal, T prevVal);

    public interface IxInput<T> : IxControl
    {
        T Value { get; set; }
        bool IsValid(); // return true if the value is valid.
        Validator<T> validator { get; set; }
        event XFormEvent ValueChanged;
    }

    public interface IxControlGroup : IxControl
    {
        IxControl this[string name] {get;}
        IxInput<T> Get<T>(string name);
        IEnumerator<IxControl> EnumChildren();
    }
}
