﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.framework
{
    [Serializable]
    public abstract class VAbstractIdentifier : IIdentifier
    {
        protected readonly string _idstr;

        protected VAbstractIdentifier(string IdStr)
        {
            this._idstr = IdStr;
        }

        public override bool Equals(object target)
        {
            VAbstractIdentifier another = target as VAbstractIdentifier;
            if (another == null) return false;
            return this._idstr.Equals(another._idstr) && this.GetType().Equals(another.GetType());
        }

        public override int GetHashCode()
        {
            return this._idstr.GetHashCode();
        }

        public override string ToString()
        {
            return String.Format("{0}'{1}'", this.GetType().Name, this.AsString);
        }
    
        public string AsString
        {
            get { return _idstr; }
        }
    }
}
