﻿using nft.contributions.graphics;
using nft.core.graphics;
using nft.framework.plugin;
using System;
using System.Collections.Generic;
using System.Text;
using ConditionedTextureSrc = nft.core.view.ConditionedResource<nft.core.graphics.TextureSrc>;

namespace nft.core.structure {
    public class SkinCatalog : ICatalogSource<ConditionedTextureSrc> {
        static protected WeakReference Cache = new WeakReference(null);

        public static SkinCatalog Get() {
            if (!Cache.IsAlive || Cache.Target==null) {
                Cache.Target = new SkinCatalog();
            }
            return Cache.Target as SkinCatalog;
        }

        protected CatalogVariableCollection varCollection;
        protected CatalogVarCollectionElement varElement;

        protected SkinCatalog() {
            init();
        }
        protected void init(){
            varCollection = new CatalogVariableCollection();
            PluginManager pm = PluginManager.theInstance;
            IEnumerable<CtbStructureSkin> contribs = pm.EnumContributions<CtbStructureSkin>();
            // TODO: 同名でグループ化したツリー構造化
            List<CtbStructureSkin> list = new List<CtbStructureSkin>(contribs);
            CatListVariable<CtbStructureSkin> var = new CatListVariable<CtbStructureSkin>(list, true);
            varElement = new CatalogVarCollectionElement(CatalogVarNameConstants.Design,"種類");
            varElement.Variable = var;
            varCollection.AddElement(varElement);
        }

        public CatalogVariableCollection VariableCollection {
            get { return varCollection; }
        }

        #region ICatalogSource implementation
        public IEnumerable<KeyValuePair<string, ICatalogVariable>> CatalogVariables {
            get { 
                yield return new KeyValuePair<string, ICatalogVariable>(varElement.Name, varElement.Variable);
                yield break;
            }
        }

        public bool Select(CatalogVariableCollection.ValueMap valueMap, out ConditionedTextureSrc result, out ICatalogSource<ConditionedTextureSrc> child) {
            object val = valueMap[CatalogVarNameConstants.Design];
            CatListVariable<CtbStructureSkin> var = valueMap[CatalogVarNameConstants.Design] as CatListVariable<CtbStructureSkin>;
            CtbStructureSkin ctbSkin = var.Current;
            result = null;
            child = null;
            if (ctbSkin == null) return false;
            child = ctbSkin.TextureSet;
            return true;
        }
        #endregion
    }

}
