﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using nft.framework.drawing;

namespace nft.core.game {
    public delegate void PointerEventHandler(PointerEventArgs pe);

    public class PointerEventArgs : EventArgs{
        protected MouseEventArgs eventOrg;
        protected IGame game;
        protected ISurface surface;

        public PointerEventArgs(MouseEventArgs org, IGame gm, ISurface surf) {
            this.eventOrg = org;
            this.game = gm;
            this.surface = surf;
        }

        public IGame Game {
            get {
                return game;
            }
        }

        public ISurface Surface {
            get {
                return surface;
            }
        }

        public MouseEventArgs OriginalEventArgs {
            get {
                return eventOrg;
            }
        }
    }
}
