﻿using System;
using System.Collections.Generic;
using System.Text;
using SysColor = System.Drawing.Color;
using System.Drawing;
using System.Windows.Forms;
using nft.framework.drawing;
using nft.core.geometry;
using nft.framework;
using System.Diagnostics;

namespace nft.core
{
    public class GraphicManagerEx : IGraphicManager
    {
        #region Singleton
        private static GraphicManagerEx theInstance;
        static GraphicManagerEx() {
            IGraphicManager core = (IGraphicManager)GlobalModules.GetModule(typeof(IGraphicManager));
            theInstance = new GraphicManagerEx(core);
        }

        static public GraphicManagerEx GraphicManager {
            get { return theInstance; }
        }

        static public void ReloadCore(){
            theInstance.entity =(IGraphicManager)GlobalModules.GetModule(typeof(IGraphicManager));
        }
        #endregion

        private IGraphicManager entity;
        public GraphicManagerEx(IGraphicManager original) {
            this.entity = original;
        }

        #region IGraphicManager implementation
        public IImageSrc LoadImageFromFile(ResourceKey rkey, IFileSource file, SysColor colorkey) {
            return entity.LoadImageFromFile(rkey, file, colorkey);
        }

        public IImageSrc LoadImageFromFileWithDefaultColorKey(ResourceKey rkey, IFileSource file) {
            return entity.LoadImageFromFileWithDefaultColorKey(rkey, file);
        }

        public ITexture CreateStaticTexture(ResourceKey rkey, IImageSrc src, Rectangle region) {
            return entity.CreateStaticTexture(rkey, src);
        }

        public ITexture CreateStaticTexture(ResourceKey rkey, IImageSrc src) {
            return entity.CreateStaticTexture(rkey, src);
        }

        public ITerrainPlateTemplate CreateTerrainTemplate(ResourceKey rkey, ITexture texture, Point3D[] vertices, PointF[] texture_pos, float brightness) {
            return entity.CreateTerrainTemplate(rkey, texture, vertices, texture_pos, brightness);
        }

        public ITerrainPlateTemplate CreateTerrainTemplate(ResourceKey rkey, SysColor basecol, Point3D[] vertices, float brightness) {
            return entity.CreateTerrainTemplate(rkey, basecol, vertices, brightness);
        }

        /*
        public ITerrainPlate CreateTerrainPlate(Location loc, ITerrainPlateTemplate template) {
            UInt32 id = (UInt32)(loc.X + loc.Y); //((loc.X << 16) + loc.Y);
            return entity.CreateTerrainPlate(id, template);
        }
        */
        
        public ITerrainPlate CreateTerrainPlate(UInt32 id, ITerrainPlateTemplate template) {
            return entity.CreateTerrainPlate(id, template);
        }

        public ICubicStructure CreateStructure(UInt32 id, ResourceKey rkey, ITexture texture, Point3D size3d) {
            return entity.CreateStructure(id, rkey, texture, size3d);
        }

        public IBillboard CreateBillboard(ITexture texture) {
            return entity.CreateBillboard(texture);
        }

        public IOverlay CreateOverlay(ITexture texture) {
            return entity.CreateOverlay(texture);
        }

        public ISurface CreateSurfaceForControl(Control parent, out Control eventtarget, SurfaceUsage usage) {
            return entity.CreateSurfaceForControl(parent, out eventtarget, usage);
        }

        public ISurface CreateSurfaceForControl(Control parent, out Control eventtarget) {
            return entity.CreateSurfaceForControl(parent, out eventtarget, SurfaceUsage.GameView);
        }

        public ISurface CreateOffscreenSurface(Size size, SurfaceUsage usage) {
            return entity.CreateOffscreenSurface(size, usage);
        }

        public IEffectFilter GetFilterByUsage() {
            return entity.GetFilterByUsage();
        }

        public Type RegistType {
            get { throw new NotImplementedException(); }
        }

        public string Name {
            get { return "GraphicManagerExtentions"; }
        }

        public string Description {
            get { return "GraphicManager Wrapper with Extentions."; }
        }
        #endregion
    }
}
