﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nft.framework;
using System.IO;
using System.Diagnostics;
using System.Reflection;
using System.Drawing;
using System.Drawing.Imaging;
using System.Threading.Tasks;
using System.Threading;
using System.Reactive.Linq;
using System.Reactive.Concurrency;
using System.Windows.Forms;

namespace nft.test.test
{
    class SomeTest
    {
       
        [TestEntry]
        static private bool TestStackFrame() {
            for (int i = 1; i < 4; i++) {
                DumpStack(i);
            }
            return true;
        }

        static private void DumpStack(int skip) {
            Debug.WriteLine("####Dump StackFrame of "+skip+" ###");
            StackFrame callerFrame = new StackFrame(skip);
            MethodBase callerMethod = callerFrame.GetMethod();
            Type callerType = callerMethod.ReflectedType;
            Debug.WriteLine("FullName=" + callerType.FullName);
            Debug.WriteLine("Name=" + callerType.Name);
            Debug.WriteLine("Namespace=" + callerType.Namespace);
            Debug.WriteLine("BaseType=" + callerType.BaseType.FullName);
            Debug.WriteLine("ReflectedType=" + callerType.ReflectedType);
        }

        [TestEntry]
        static private bool TestConverter() {
            object o;
            o = Convert.ChangeType("123", typeof(long));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            o = Convert.ChangeType(456, typeof(string));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            o = Convert.ChangeType("10.82", typeof(float));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            o = Convert.ChangeType("5/2", typeof(DateTime));
            Debug.WriteLine(o.ToString() + "<<" + o.GetType().Name);
            return true;
        }

        [TestEntry(new object[]{2000,2000,10})]
        static private bool TestGC(int img_width, int img_height, int loop) {
            Bitmap bmp = new Bitmap(img_width, img_height, PixelFormat.Format32bppArgb);
            Bitmap b2 = bmp;
            for (int i = 0; i < loop; i++) {
                b2 = b2.Clone() as Bitmap;
                Debug.WriteLine("TotalMem=" + GC.GetTotalMemory(true));
                Debug.Write("bmp=" + GC.GetGeneration(bmp));
                Debug.WriteLine(", b2=" + GC.GetGeneration(b2));
            }
            return true;
        }

        [TestEntry(new object[]{@"C:\test\testsub"})]
        [TestEntry(new object[] { "file://c:/test/testsub" })]
        [TestEntry(new object[] { "http://test.com/test/testsub2" })]
        static private string TestUri(string path) {
            Uri u = new Uri(path);
            Debug.WriteLine("abPath="+u.AbsolutePath);
            string localpath = u.LocalPath;
            Debug.WriteLine(localpath);
            return Path.GetFileName(localpath);
        }

        [TestEntry(new object[] { @"C:\test\testsub.xml" })]
        [TestEntry(new object[] { "file://c:/test/testsub" })]
        [TestEntry(new object[] { "http://test.com/test/testsub2.xml" })]
        static private string TestPath(string path) {
            try {
                Debug.WriteLine("FullPath=" + Path.GetFullPath(path));
            } catch (Exception e) {
                Debug.WriteLine(e.Message);
            }
            Debug.WriteLine("DirectoryName=" + Path.GetDirectoryName(path));
            Debug.WriteLine("PathRoot=" + Path.GetPathRoot(path));
            Debug.WriteLine("FileName=" + Path.GetFileName(path));
            Debug.WriteLine("Extension=" + Path.GetExtension(path));
            return Path.GetFileName(Path.GetDirectoryName(path) + "");
        }


        [TestEntry]
        static private async void TestAsync() {
            // .NET4.5 のasync/awaitテスト
            Debug.WriteLine("start TestAsync");            
            await Task.Run(() => Thread.Sleep(3000));
            Debug.WriteLine("end TestAsync");
        }

        [TestEntry]
        static private void TestRx() {
            // Rx.NETのテスト
            Debug.WriteLine("start TestRx");
            var ix = from x in Enumerable.Range(1, 10)
                where x % 2 == 0
                select x * x;
            Debug.WriteLine(ix);

            Observable.Range(0, 10).Where(x => 0 == x % 2).Select(x => x + 1000)
                .Subscribe((v) => Debug.WriteLine(v));

            IScheduler sch = new ControlScheduler(Application.OpenForms[0]);
            Observable.Range(0, 10).Delay(TimeSpan.FromSeconds(1)).ObserveOn(sch)
                .Subscribe(v => Debug.WriteLine(v));

            Debug.WriteLine("end TestRx");
        }
    }


}
