﻿using nft.contributions.ui;
using nft.framework.plugin;
using System;
using System.Collections.Generic;
using System.Text;
using WeifenLuo.WinFormsUI.Docking;

namespace nft.ui.docking {
    public interface IDockContentFactory {
        DockContent CreateDockContent(string subkey);
    }

    public class DockContentContributionResolver {
        public static readonly string SepalatorPersist = "::";
        public static DockContent ResolveDockContent(string persist) {
            int n = persist.IndexOf(SepalatorPersist);
            string id = persist.Substring(0, n);
            string nam = persist.Substring(n + SepalatorPersist.Length);
            Contribution ctb = PluginManager.theInstance.GetContribution(new VContributionId(id));
            IDockContentFactory fct = ctb as IDockContentFactory;
            if (fct != null) {
                return fct.CreateDockContent(nam);
            }
            CtbCommand cmd = ctb as CtbCommand;
            if (cmd != null && cmd.Commandprocedure is IDockContentFactory) {
                fct = cmd.Commandprocedure as IDockContentFactory;
                return fct.CreateDockContent(nam);
            }
            return null;
        }
    }
}
