﻿using nft.framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.framework.repository
{
    /// <summary>
    /// データリポジトリビルダーのインターフェース
    /// 標準実装はRepositoryBuilderBase
    /// </summary>
    /// <typeparam name="S"></typeparam>
    /// <typeparam name="T"></typeparam>
    public interface IRepositoryBuilder<S,T> where S: IIdentifier where T: IHasNameAndID
    {
        /// <summary>
        /// モデルを追加する。既にモデル
        /// </summary>
        /// <param name="model"></param>
        void Add(T model);

        /// <summary>
        /// IDで指定したモデルを削除し、削除したモデルを返す。該当モデルが存在しない場合エラーにはならず、nullを返す。
        /// </summary>
        /// <param name="id"></param>
        /// <returns>removed model or null if not exist</returns>
        T RemoveByID(S id);


        IRepository<S,T> Finalize();
    }


    
}
