﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.framework.plugin
{
    [Serializable]
    public sealed class VPluginId : VAbstractIdentifier
    {
        public static readonly VPluginId System = new VPluginId("system");

        public static VPluginId FromString(string idstr)
        {
            return new VPluginId(idstr);
        }

        public VPluginId(Uri path) : this(MakeIdStr(path))
        {}

        private VPluginId(string pluginId) : base(WithValidation(pluginId))
        {}

        private static string MakeIdStr(Uri path)
        {
            String str = path.LocalPath.Replace("/", "\\");
            String dirpath = Path.GetExtension(str).ToLower() == ".xml" ? Path.GetDirectoryName(str) : str;
            return Path.GetFileName(dirpath);
        }

        private static string WithValidation(string testStr)
        {
            string format = I18n.T("'{0}' contains invalid character(s) as a {1}.");
            Debug.Assert( 
                PluginUtil.IdCharValidator.IsMatch(testStr), String.Format(format, testStr, "Plugin-ID")
            );
            return testStr;
        }
    }
}
