﻿using nft.core;
using nft.framework;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.impl.game
{
    public class VDistrictId : VAbstractIdentifier
    {

        public static readonly string PREFIX = "District:";

        internal static VDistrictId Generate(World w, Point pos)
        {
            string idStr = $"District:{((VWorldId)w.ID).ShortID}-{pos.X:00}{pos.Y:00}-{DateTime.Now.Ticks}";
            return new VDistrictId(idStr);
        }

        private VDistrictId(string idStr) : base(idStr) { }

        public string ShortID
        {
            get
            {
                int n = this.AsString.LastIndexOf("-");
                long tick = long.Parse(this.AsString.Substring(n + 1));
                return $"{tick:X}";
            }
        }
    }
}
