﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.core.geometry;

namespace nft.core.structure {
    public class StructureCollection {
        protected List<Lot> list;

        public StructureCollection() {
        }

        public void Add(Lot l) {
            list.Add(l);
        }

        public void Remove(Lot l) {
            list.Remove(l);
        }

        public List<Lot> GetCollidings(Lot l) {
            List<Lot> result = new List<Lot>();
            foreach (Lot l2 in list) {
                if (l2 == l) continue;
                if (l2.IsCollide(l)) {
                    // TODO more detalied evaluations.
                    result.Add(l2);
                }
            }
            return result;
        }

        public StructuresEnumerator GetEnumeratorForView(Rect3D region) {
            return new StructuresEnumerator(this, region);
        }

        public class StructuresEnumerator : IEnumerable<Lot> {
            StructureCollection lots;
            Rect3D region;
            internal protected StructuresEnumerator(StructureCollection lots, Rect3D region) {
                this.lots = lots;
                this.region = region;
            }

            public IEnumerator<Lot> GetEnumerator() {
                foreach(Lot l in lots.list){
                    if(region.IsIntersect(l.Bounds)){
                        yield return l;
                    }
                }
                yield break;
            }

            System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() {
                return GetEnumerator();
            }
        }
        public class PlanarStructuresEnumerator : IEnumerable<Lot> {
            StructureCollection lots;
            Rect3D region;
            internal protected PlanarStructuresEnumerator(StructureCollection lots, Rect3D region) {
                this.lots = lots;
                this.region = region;
            }

            public IEnumerator<Lot> GetEnumerator() {
                foreach (Lot l in lots.list) {
                    Rect3D r3d = l.Bounds;
                    if (region.X>r3d.X2 || region.X2<r3d.X || region.Y>r3d.Y2 || region.Y2<r3d.Y) {
                        continue; // Planar area (x,y) is outside of region
                    }
                    yield return l;
                }
            }

            System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() {
                return GetEnumerator();
            }
        }
    }
    

}
