using System;
using System.Drawing;
using System.Windows.Forms;

namespace nft.framework.drawing
{
	public enum SurfaceAlloc { Auto, VideoMem, SystemMem };

	/// <summary>
	/// IGraphicManager ̊Tv̐łB
	/// </summary>
	public interface IGraphicManagerOld : IGlobalModule{

		/// <summary>
		/// Creates a primitive ITexture instance from specified region of image.
		/// </summary>
        /// <param name="imageRef"></param>
		/// <param name="region"></param>
		/// <param name="offset"></param>
        /// <returns></returns>
        IStaticTexture CreateStaticTexture(ImageRef imageRef, Rectangle region, Point offset);

        /// <summary>
        /// Creates a primitive ITexture instance which based on an image.
        /// Use whole image as Texture.
        /// </summary>
        /// <param name="image"></param>
        /// <param name="offset"></param>
        /// <returns></returns>
        IStaticTexture CreateStaticTexture(Image image, Point offset);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="source"></param>
		/// <param name="region"></param>
		/// <param name="offset"></param>
        /// <param name="copyBits">if true, copy bitmap data and keep them.</param>
        /// <returns></returns>
        IStaticTexture CreateStaticTexture(ISurfaceOld source, Rectangle region, Point offset, bool shareSurface);

		ISurfaceOld CreateOffscreenSurface(Size size);

		/// <summary>
		/// Creates an off-screen surface from an image.
		/// </summary>
		/// <param name="source"></param>
		/// <param name="alloc"></param>
		/// <returns></returns>
		ISurfaceOld CreateSurfaceFromBitmap(Image source, Rectangle region);
        ISurfaceOld CreateSurfaceFromBitmap(Image source);

		/// <summary>
		/// Creates an instance of sprite.
		/// </summary>
		/// <param name="texture"></param>
		/// <returns></returns>
		ISprite CreateSprite( ITextureOld texture );

		/// <summary>
		/// Creates a DrawableControl which contains primary surface
		/// </summary>
		/// <returns></returns>
		DrawableControl CreateDrawableControl();

		#region ISurfaceDrawer factories
		/// <summary>
		/// create intersect drawer
		/// draws only when both source and destination pixel is not transpalent
		/// this drawer must be necessary for drawing perspective scenes
		/// </summary>
		/// <returns></returns>
		ISurfaceDrawer GetIntersectDrawer();
		/// <summary>
		/// create 50% alpha blend drawer
		/// </summary>
		/// <returns></returns>
		ISurfaceDrawer GetHalfAlphaDrawer();
		/// <summary>
		/// create color burn drawer
		/// this drawer is used for red sunset and morning haze
		/// </summary>
		/// <param name="c"></param>
		/// <param name="apply"></param>
		/// <returns></returns>
		ISurfaceDrawer GetColorBurnDrawer(Color c, float apply);
		/// <summary>
		/// create mono color drawer
		/// draws gray-scaled image with specified color
		/// this drawer is used for setting highlihgt some sprites.
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		ISurfaceDrawer GetMonoColorDrawer(Color c);
		/// <summary>
		/// create brighter drawer
		/// draws only when source pixel is brighter than destination
		/// this drawer is used for red sunset and morning haze
		/// </summary>
		/// <returns></returns>
		ISurfaceDrawer GetBrighterDrawer();
		#endregion

		/// <summary>
		/// Returns current display color mode.
		/// </summary>
		PixelColorMode CurrentColorMode { get; }

		/// <summary>
		/// Retruns total amount of video memory.
		/// </summary>
		int TotalVideoMemory { get; }

		/// <summary>
		/// Retruns current available amount of video memory.
		/// </summary>
		int AvailableVideoMemory { get; }
	}
}
