using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
using System.Xml;
//using Microsoft.Win32;
using nft.util;
using nft.ui;
using nft.ui.mainframe_old;
using nft.framework.plugin;
using System.Drawing;
using System.Runtime;
using nft.framework.drawing;
using System.Reflection;
using nft.ui.mainframe;

namespace nft.framework
{

	/// <summary>
	/// Entry point to other static instances in the NeoFreeTrain framework.
	/// </summary>
    // [Ql] https://msdn.microsoft.com/ja-jp/library/system.windows.forms.applicationcontext(v=vs.110).aspx
    public sealed class Main : ApplicationContext {

        private static Main theInstance;
	
        public Main(string[] args) {
            theInstance = this;
            I18n.LoadFile(Directories.AppBaseDir + "nftfw.resource.xml");

            using (Splash s = new Splash()) {
                s.Show();

                // Handle the ApplicationExit event to know when the application is exiting.
                Application.ApplicationExit += new EventHandler(this.OnApplicationExit);

                InitDirectoriesAndAssemblies(args);
                InitGlobalModules();
                Debug.Assert(theFrame!=null,"GlobalModule should set theFrame while it's Initialization.");

                ProgressMonitor monitor = CreateProgressMonitor(new ProgressHandler(s.updateMessage));
                InitPlugins(monitor);

                theFrame.Show();
            }

            FireInitCompleteEvent();
        }

        /// <summary> the main window frame </summary>
        private static IMainFrame theFrame;
        public static IMainFrame mainFrame { get { return theFrame; } }

        /// <summary>
        /// Set the mainframe instance, called from GlobalModules when initialize called.
        /// </summary>
        /// <param name="frame"></param>
        internal static void setFrame(IMainFrame frame) { theFrame = frame; }

        public static EventHandler InitComplete;

        /// <summary> Main resources. </summary>
        //public static readonly NftProperties resources = NftProperties.LoadFromFile(Directories.AppBaseDir + "nftfw.resource.xml", false);

        /// <summary> Plug-ins. </summary>
        public static readonly PluginManager pluginManager = new PluginManager();

        // Exit entire application.
        public static void Exit() {
            if (theInstance != null) {
                theInstance.ExitThread();
                theInstance = null;
            }
        }

        // Exit application with Action to be called on Exit
        public static void Exit(Action<object> Callback, object arg) {
            Application.ApplicationExit += (sender, e) => Callback(arg);
            Main.Exit();
        }

        private void InitDirectoriesAndAssemblies(string[] args) {
            Hashtable h_args = paresArgs(args);
            InitializeAssemblies();
            Directories.Initialize(h_args);
        }

        private void InitGlobalModules() {
            Application.DoEvents();
            // load global modules;
            GlobalModules.Initialize();
        }

        private void InitPlugins(ProgressMonitor monitor) {
            Application.DoEvents();
            // load plug-ins
            Main.pluginManager.init(new string[] { Directories.PluginDir }, monitor);
        }

        private void OnApplicationExit(object sender, EventArgs e) {
            Debug.WriteLine("## Application Exit ##");
        }

        private ProgressMonitor CreateProgressMonitor(ProgressHandler progressHandler) {
            ProgressMonitor monitor = new ProgressMonitor(2);
            monitor.SetMaximum(1, 5);
            if (progressHandler != null) monitor.OnProgress += progressHandler;
            return monitor;
        }

        private static Hashtable paresArgs(string[] args) {
            Hashtable table = new Hashtable();
            for (int i = 0; i < args.Length; i++) {
                string[] v = args[i].Split(new char[] { '=' }, 2);
                if (v.Length == 2)
                    table.Add(v[0].ToUpper(), v[1]);
                else
                    table.Add(v[0].ToUpper(), string.Empty);
            }
            return table;
        }

        private void FireInitCompleteEvent() {
            if (InitComplete != null) InitComplete(this, new EventArgs());
        }

        private static void InitializeAssemblies() {
            AppDomain.CurrentDomain.AssemblyLoad += new AssemblyLoadEventHandler(AssemblyInitializer);
            Assembly[] asms = AppDomain.CurrentDomain.GetAssemblies();
            foreach (Assembly asm in asms) {
                AssemblyInitializer(null, new AssemblyLoadEventArgs(asm));
            }
        }

        private static void AssemblyInitializer(object sender, AssemblyLoadEventArgs args) {
            Assembly asm = args.LoadedAssembly;
            if (asm.GlobalAssemblyCache)
                return;
            // force static constructors in types specified by InitializeOnLoad
            object[] attributes = asm.GetCustomAttributes(typeof(InitializeOnLoadAttribute), false);
            foreach (InitializeOnLoadAttribute attr in attributes) {
                System.Runtime.CompilerServices.RuntimeHelpers.RunClassConstructor(attr.Type.TypeHandle);
                Debug.WriteLine("Init class on load assembly: class=" + attr.Type.FullName + ", module=" + Path.GetFileName(asm.CodeBase));
            }
        }

    }
}
