using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.core.game;
using nft.core.geometry;
using nft.core.structure;
using nft.util;
using nft.framework.drawing;
using System.Text;
using System.IO;
using System.Collections.Generic;

namespace nft.contributions.terrain
{
	/// <summary>
    /// CtbTerrainTextureFactory ̊Tv̐łB
	/// </summary>     
    [Obsolete]
    public class CtbGroundTextureFactory : CtbCustomCtbFactory
	{
        public static readonly Color texBGColor = Color.Magenta;
        public static readonly Color texFGColor = Color.Cyan;

        //private static CtbTerrainTextureFactory theInstance;
        //public static ITexture GetSilhouetteTexture(Scaler scl, short id) {
        //    return theInstance.GetTexture(scl, id);
        //}
        
        // Template set of Ground Images. Used for like a clipping mask.
        protected PlainGroundImgSet imageSet;

        public CtbGroundTextureFactory(Plugin p, ParamsReader contrib)
            : base(p, contrib) {
            imageSet = new PlainGroundImgSet(DataDirectory);
        }

        //protected override InitCompleteEventHandler Initialize() {
        //    return base.Initialize();
        //}

        public override void PrepareCacheData(bool forceUpdate) {
            // check existence or create pattern images.
            if (forceUpdate)
                imageSet.DeleteCache();
            imageSet.PrepareCache();
        }

        protected override Contribution Create(Plugin owner, ParamsReader e)
        {
            //TODO:eNX`摜Ή̒n`eNX`c
            return new CtbSimpleGroundTexture(owner, this, e);
        }

        /// <summary>
        /// Returns two-tone colored ground piece texture. Useful for clipping mask.
        /// </summary>
        /// <param name="scl"></param>
        /// <param name="id"></param>
        /// <param name="hint"></param>
        /// <returns></returns>
        public ITextureOld GetTexture(Scaler scl, ushort id, Point3DV hint) {
            return imageSet.GetTexture(scl, GroundPolygon.GetPolygon(id), hint);
        }

        /// <summary>
        /// Retruns two-tone colored ground piece image. Useful for clipping mask.
        /// </summary>
        /// <param name="scl"></param>
        /// <param name="id"></param>
        /// <param name="hint"></param>
        /// <returns></returns>
        public Image GetTextureBitmap(Scaler scl, ushort id, Point3DV hint) {
            try {
                return imageSet[scl, id, hint];
            } catch (FileNotFoundException) {
                return null;
            }
        }

        /// <summary>
        /// Two-tone colored sinple ground piece textures
        /// </summary>
        protected class PlainGroundImgSet : AbstractGroundImgSet {
            public PlainGroundImgSet(string path) : base(path) { }

            protected override Bitmap CreateBitmap(Scaler sc, GroundPolygon polygon, Point3DV hint) {
                Point[] pts = polygon.GetVerticis(sc);
                Rectangle rect = new Rectangle();
                return PrimitiveTextrueFactory.CreatePolygonBitmap
                    (pts, texFGColor, texBGColor, ref rect);                
            }
        }

    }
}
