//-----------------------------------------------------------------------------
// PostprocessEffect.fx
//
// Microsoft XNA Community Game Platform
// Copyright (C) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

// This source is based on following sample.
// http://xbox.create.msdn.com/ja-JP/education/catalog/sample/nonrealistic_rendering

// GbWotB^[𐧌䂷ݒB

// GbWoł̓̓f[^̔ȕωɑ΂銴x͂ǂ̒xɂ܂B
// ݒ΂قǁAȃGbWo悤ɂȂAl傫ƁA
// svȃmCY͏O܂B
// Sʂ̊x@right, left, top, bottom
float4 DepthThreshold = 0.02;

// ̓f[^̕ωɑΉāAǂ̒xGbWÂ܂B
float DepthMultiplyer = 25;
// Sʂ̋x@right,left, top, bottom
float4 EdgeStrength = 0.4;

// ݂̉ʂ̉𑜓xn܂B
float2 ScreenResolution;

float4x4 MatrixTransform;


// ̃eNX`ɂ́AC̃V[̃C[W܂܂܂B̏ɁAGbWo
// уXPb` tB^[܂͂̂ꂩKp܂B
texture SceneTexture;

sampler SceneSampler : register(s0) = sampler_state
{
    Texture = (SceneTexture);
    
    MinFilter = Linear;
    MagFilter = Linear;
    
    AddressU = Clamp;
    AddressV = Clamp;
};


// ̃eNX`ɂ́AC̃V[̃C[W̖@ (J[ `l) 
// [x (At@)܂܂܂B@f[^Ɛ[xf[^̍قgpāA
// f̃GbẄʒuo܂B
texture NormalDepthTexture;

sampler NormalDepthSampler : register(s1) = sampler_state
{
    Texture = (NormalDepthTexture);
    
    MinFilter = Linear;
    MagFilter = Linear;
    
    AddressU = Clamp;
    AddressV = Clamp;
};

// GbWoPixelShader
// [xɉ1px̋PxቺC܂
float4 PSEdgeDetect(float2 texCoord : TEXCOORD0) : COLOR0
{
    // C̃V[猳̐F܂B
    float3 scene = tex2D(SceneSampler, texCoord);
        
    // YsNZсA 4 ̗אڃsNZƂ̐[x擾B
    float2 edgeOffset = 1 / ScreenResolution;
    float n0 = tex2D(NormalDepthSampler, texCoord).a;
    float n1 = tex2D(NormalDepthSampler, texCoord + float2( 1, 0) * edgeOffset).a;
    float n2 = tex2D(NormalDepthSampler, texCoord + float2(-1, 0) * edgeOffset).a;
    float n3 = tex2D(NormalDepthSampler, texCoord + float2( 0, 1) * edgeOffset).a;
    float n4 = tex2D(NormalDepthSampler, texCoord + float2( 0,-1) * edgeOffset).a;
    // [x̒lǂꂾωo܂BȕωtB^[ŏO܂B
    float d1 = saturate((n0-n1-DepthThreshold.x)*DepthMultiplyer)*EdgeStrength.x;
	float d2 = saturate((n0-n2-DepthThreshold.y)*DepthMultiplyer)*EdgeStrength.y;
	float d3 = saturate((n0-n3-DepthThreshold.z)*DepthMultiplyer)*EdgeStrength.z;
	float d4 = saturate((n0-n4-DepthThreshold.w)*DepthMultiplyer)*EdgeStrength.w;
    float delta = max(max(d1,d2),max(d3,d4));
    // GbWǒʂC̃V[̐FɓKp܂B
    scene *= (1 - delta);
	
    return float4(scene, 1);
}

//SrcAlphaGrayscaleɕϊPixelShader
float4 PSAlphaToGS(float2 texCoord : TEXCOORD0) : COLOR0
{
	float4 depth = tex2D(NormalDepthSampler, texCoord);
	float4 gs = depth.a;
	gs.a = 1.0;
	return gs;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, MatrixTransform);
}

// GbWoF[xɉ1px̋PxቺC܂
technique EdgeDetect
{
    pass P0
    {
        VertexShader = compile vs_2_0 SpriteVertexShader();
        PixelShader = compile ps_2_0 PSEdgeDetect();
    }
}

// \[XAlphaO[XP[ă_OiDebug usej
technique AlphaToGS
{
    pass P0
    {
        VertexShader = compile vs_2_0 SpriteVertexShader();
        PixelShader = compile ps_2_0 PSAlphaToGS();
    }
}